﻿---
title: Authentication realms
description: Elastic authenticates users by using realms and one or more token-based authentication services. A realm is used to resolve and authenticate users based...
url: https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/authentication-realms
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Authentication realms
Elastic authenticates users by using realms and one or more [token-based authentication services](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/token-based-authentication-services).
A *realm* is used to resolve and authenticate users based on authentication tokens. There are two types of realms:
<definitions>
  <definition term="Internal">
    Realms that are internal to Elasticsearch and don’t require any communication with external parties. They are fully managed by Elasticsearch. There can only be a maximum of one configured realm per internal realm type. Elasticsearch provides two internal realm types: `native` and `file`.
  </definition>
  <definition term="External">
    Realms that require interaction with parties and components external to Elasticsearch, typically with enterprise grade identity management systems. Unlike internal realms, you can have as many external realms as you would like, each with its own unique name and configuration. [View external realm types](#external-realms).
  </definition>
</definitions>


## Configuring realms

To learn how to configure and use a specific realm, follow the documentation for the realm that you want to use. You can also configure a custom realm by building a [custom realm plugin](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/custom).
You can also perform the following tasks to further configure your realms:
- Prioritize your realms using [realm chains](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/realm-chains).
- Allow a single user to authenticate using multiple realms by grouping them together in a [security domain](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/security-domains).


## Internal realms

Elasticsearch provides the following built-in internal realms:
<definitions>
  <definition term="native">
    Users are stored in a dedicated Elasticsearch index. This realm supports an authentication token in the form of username and password, and is available by default when no realms are explicitly configured. Users are managed through Kibana, or using [user management APIs](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-security). See [Native user authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/native).
  </definition>
  <definition term="file">
    Users are defined in files stored on each node in the Elasticsearch cluster. This realm supports an authentication token in the form of username and password and is always available. See [File-based user authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/file-based). Available for Elastic Cloud on Kubernetes and self-managed deployments only.
  </definition>
</definitions>


## External realms

Elasticsearch provides the following built-in external realms:
<definitions>
  <definition term="ldap">
    Uses an external LDAP server to authenticate the users. This realm supports an authentication token in the form of username and password, and requires explicit configuration in order to be used. LDAP is not available on Elastic Cloud Hosted deployments. For more information, refer to [LDAP user authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/ldap).
  </definition>
  <definition term="active_directory">
    Uses an external Active Directory Server to authenticate the users. With this realm, users are authenticated by usernames and passwords. Active Directory is not available on Elastic Cloud Hosted deployments. For more information, refer to [Active Directory user authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/active-directory).
  </definition>
  <definition term="pki">
    Authenticates users using Public Key Infrastructure (PKI). This realm works in conjunction with SSL/TLS and identifies the users through the Distinguished Name (DN) of the client’s X.509 certificates. PKI is not available on Elastic Cloud Hosted deployments. For more information, refer to [PKI user authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/pki).
  </definition>
  <definition term="saml">
    Facilitates authentication using the SAML 2.0 Web SSO protocol. This realm is designed to support authentication through Kibana and is not intended for use in the REST API. For more information, refer to [SAML authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/saml).
  </definition>
  <definition term="kerberos">
    Authenticates a user using Kerberos authentication. Users are authenticated on the basis of Kerberos tickets. For more information, refer to [Kerberos authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kerberos).
  </definition>
  <definition term="oidc">
    Facilitates authentication using OpenID Connect. It enables Elasticsearch to serve as an OpenID Connect Relying Party (RP) and provide single sign-on (SSO) support in Kibana. For more information, refer to [Configuring single sign-on to the Elastic Stack using OpenID Connect](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/openid-connect).
  </definition>
  <definition term="jwt">
    Facilitates using JWT identity tokens as authentication bearer tokens. Compatible tokens are OpenID Connect ID Tokens, or custom JWTs containing the same claims. For more information, refer to [JWT authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/jwt).
  </definition>
</definitions>


## Custom realms

If you need to integrate with another authentication system, you can build a custom realm plugin. For more information, see [Integrating with other authentication systems](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/custom).