﻿---
title: Anonymous access
description: Incoming requests to Elasticsearch are considered to be anonymous if no authentication token can be extracted from the incoming request. By default, anonymous...
url: https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/anonymous-access
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Anonymous access
<tip>
  To embed Kibana dashboards or grant access to Kibana without requiring credentials, use Kibana's [anonymous authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-authentication) feature instead.
</tip>

Incoming requests to Elasticsearch are considered to be *anonymous* if no authentication token can be extracted from the incoming request. By default, anonymous requests are rejected and an authentication error is returned (status code `401`).
To enable anonymous access, you assign one or more roles to anonymous users in the [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) configuration file. For example, the following configuration assigns anonymous users `role1` and `role2`:
```yaml
xpack.security.authc:
  anonymous:
    username: anonymous_user 
    roles: role1, role2 
    authz_exception: true 
```