﻿---
title: Cluster or deployment users
description: To prevent unauthorized access to your Elastic resources, you need a way to identify users and validate that a user is who they claim to be (authentication),...
url: https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth
products:
  - Elastic Cloud Enterprise
  - Elastic Cloud Hosted
applies_to:
  - Elastic Stack: Generally available
---

# Cluster or deployment users
To prevent unauthorized access to your Elastic resources, you need a way to identify users and validate that a user is who they claim to be (*authentication*), and control what data users can access and what tasks they can perform (*authorization*).
In this section, you’ll learn how to set up authentication and authorization at the cluster or deployment level, and learn about the underlying security technologies that Elasticsearch uses to authenticate and authorize requests internally and across services.
This section only covers direct access to and communications with an Elasticsearch cluster - sometimes known as a deployment - as well as the related Kibana instance. To learn about managing access to your Elastic Cloud organization or Elastic Cloud Enterprise orchestrator, or to learn how to use single sign-on to access a cluster using your Elastic Cloud credentials, refer to [Users and roles](https://www.elastic.co/docs/deploy-manage/users-roles).
<admonition title="Control access to Serverless projects">
  If you use Elastic Cloud Serverless, you can only manage authentication at the [Elastic Cloud organization level](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization).
</admonition>


## Quickstart

If you plan to use native Elasticsearch user and role management, then [follow our quickstart](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/quickstart) to learn how to set up basic authentication and authorization features, including [spaces](https://www.elastic.co/docs/deploy-manage/manage-spaces), [roles](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/user-roles), and [native users](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/native).

### User authentication

Set up methods to identify users to the Elasticsearch cluster.
Key tasks for managing user authentication include:
- [Managing built-in users](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/built-in-users)
- [Managing users natively](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/native)
- [Integrating with external authentication providers](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/external-authentication)

You can also learn the basics of Elasticsearch authentication, learn about accounts used to communicate within an Elasticsearch cluster and across services, and perform advanced tasks.
[View all user authentication docs](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/user-authentication)
<admonition title="Control access to Serverless projects">
  This topic describes using the native realm at the cluster or deployment level, for the purposes of authenticating with Elasticsearch and Kibana.
  You can also manage and authenticate users natively at the [Elastic Cloud organization](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/manage-users) level.
</admonition>


### User authorization

After a user is authenticated, use role-based access control to determine whether the user behind an incoming request is allowed to execute the request.
Key tasks for managing user authorization include:
- [Defining roles](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/defining-roles)
- Assigning [built-in roles](https://www.elastic.co/docs/reference/elasticsearch/roles) or your own roles to users
- Creating [mappings of users and groups to roles](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/mapping-users-groups-to-roles) for external authentication providers
- [Setting up field- and document-level security](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/controlling-access-at-document-field-level)

You can also learn the basics of Elasticsearch authorization, and perform advanced tasks.
[View all user authorization docs](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/user-roles)
<tip>
  User roles are also used to control access to [Kibana spaces](https://www.elastic.co/docs/deploy-manage/manage-spaces).
</tip>

<admonition title="Built-in and custom roles in Serverless">
  This topic describes built-in roles in Elastic Stack clusters and deployments and explains how to create custom ones. You can also learn about [organization-level](/docs/deploy-manage/users-roles/cloud-organization/user-roles#ec_organization_level_roles) roles and [cloud resource access roles](/docs/deploy-manage/users-roles/cloud-organization/user-roles#ec_instance_access_roles) in Elastic Cloud Serverless.
  To create custom roles for Elastic Cloud Serverless, refer to [Serverless project custom roles](https://www.elastic.co/docs/deploy-manage/users-roles/serverless-custom-roles).
</admonition>

<admonition title="Control access at the document and field level in Serverless">
  Elastic Cloud Serverless centralizes user management with [Cloud organization-level roles](/docs/deploy-manage/users-roles/cloud-organization/user-roles#ec_organization_level_roles). You can configure [document- and field-level access control](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/controlling-access-at-document-field-level) in Elastic Cloud Serverless projects as a part of a project-level custom role.
</admonition>