﻿---
title: User roles and privileges
description: Within an Elastic Cloud organization, users can have one or more roles and each role grants specific privileges. You can assign user roles when you invite...
url: https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/user-roles
products:
  - Elastic Cloud Hosted
  - Elastic Cloud Serverless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
---

# User roles and privileges
Within an Elastic Cloud organization, users can have one or more roles and each role grants specific privileges.
You can assign user roles when you [invite users to join your organization](/docs/deploy-manage/users-roles/cloud-organization/manage-users#ec-invite-users). You can also edit the roles assigned to a user later.
On this page, you'll learn the following:
- [How to edit a user's roles](#edit-a-users-roles)
- The [types of roles](#types-of-roles) available, the levels where they can be applied, and the [scope](#ec-role-scoping) of each role type
- The predefined roles available for [Elastic Cloud Hosted](#ech-predefined-roles) and [Elastic Cloud Serverless](#general-assign-user-roles-table)


## Edit a user's roles

To edit the roles assigned to a user:
1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
2. From a deployment or project on the home page, select **Manage**.
3. From the lower navigation menu, select **Organization**.
4. Find the user on the **Members** tab of the **Organization** page. Click the member name to view their roles.
5. Click **Edit roles** to change the user's roles.


## Types of roles

There are two types of roles you can assign to users:
- **Organization-level roles:** These roles apply to the entire organization and are not specific to any serverless project or hosted deployment.
- **Cloud resource access roles:** These roles are specific to each serverless project or hosted deployment.


### Organization-level roles

- **Organization owner**: The role assigned by default to the user who created the organization. Organization owners have all privileges to Elastic Cloud resources including Elastic Cloud Hosted deployments and Elastic Cloud Serverless projects, as well as users, organization-level details and properties, billing details and subscription levels. They are also able to sign on to deployments with superuser privileges.
- **Billing admin**: Can manage an organization’s billing details such as credit card information, subscription and invoice history. Cannot manage other organization or deployment details and properties.


### Cloud resource access roles

You can set cloud resource access roles at two levels:
- **Globally**, for all Elastic Cloud Hosted deployments, or for all Elastic Cloud Serverless projects of the same type (Elasticsearch Serverless, Observability, or Elastic Security). In this case, the role will also apply to new deployments, or projects of the specified type type, created later.
- **Individually**, for specific deployments or projects only. To do that, you have to leave the **Role for all hosted deployments** field, or the **Role for all** for the project type, blank.

Elastic Cloud Hosted deployments and Elastic Cloud Serverless projects each have a set of predefined cloud resource access roles available:
- [Elastic Cloud Hosted predefined roles](#ech-predefined-roles)
- [Elastic Cloud Serverless predefined roles](#general-assign-user-roles-table)

If you're using Elastic Cloud Serverless, you can optionally [create custom roles in a project](https://www.elastic.co/docs/deploy-manage/users-roles/serverless-custom-roles). All custom roles grant the same access as the `Viewer` cloud resource access role with regards to Elastic Cloud privileges. To grant more Elastic Cloud privileges, assign more roles. Users receive a union of all their roles' privileges. To assign a custom role to users, go to **Cloud resource access** and select it from the list under the specific project it was created in.

## Elastic Cloud Hosted predefined roles

For Elastic Cloud Hosted deployments, the following predefined roles are available:
- **Admin**: Can manage deployment details, properties and security privileges, and is able to sign on to the deployment with superuser privileges. This role can be scoped to one or more deployments. In order to prevent scope expansion, only Admins on all deployments can create new deployments.
- **Editor**: Has the same rights as Admin, except from deployment creation and management of security privileges. Editors are able to sign on to the deployment with the “editor” stack role. This role can be scoped to one or more deployments.
- **Viewer**: Can view deployments, and can sign on to the deployment with the viewer Stack role. This role can be scoped to one or more deployments.


### Mapping of Elastic Cloud roles with Elastic Stack roles

There are two ways for a user to access Kibana instances of an Elastic Cloud Hosted deployment:
- [Directly with Elasticsearch credentials](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth). In this case, users and their roles are managed directly in Kibana. Users in this case don’t need to be members of the Elastic Cloud organization to access the deployment. Note that if you have several deployments, you need to manage users for each of them, individually.
- Through your Elastic Cloud organization. In this case, users who are members of your organization log in to Elastic Cloud and can open the deployments they have access to. Their access level is determined by the roles assigned to them from the **Organization** page. Elastic Cloud roles are mapped to [Elastic Stack roles](https://www.elastic.co/docs/reference/elasticsearch/roles) on a per-deployment level. When logging in to a specific deployment, users get the stack role that maps to their Elastic Cloud role for that particular deployment.

The following table shows the default mapping:

| Cloud role         | Cloud API `role_id`  | Stack role |
|--------------------|----------------------|------------|
| Organization owner | `organization-admin` | superuser  |
| Billing admin      | `billing-admin`      | none       |
| Admin              | `deployment-admin`   | superuser  |
| Editor             | `deployment-editor`  | editor     |
| Viewer             | `deployment-viewer`  | viewer     |


## Elastic Cloud Serverless predefined roles

You can apply the following predefined roles to Elastic Cloud Serverless projects. Some roles are only available to certain project types.
<tip>
  You can optionally [create custom roles in a project](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/user-roles) and apply them to your organization users.
</tip>


| Name                        | Description                                                                                                                                   | Available                                                                                                                                                                                                                                                                                                                                                                                                                            |
|-----------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Admin                       | Has full access to project management, properties, and security privileges. Admins log into projects with superuser role privileges.          | [![Elasticsearch](https://www.elastic.co/docs/deploy-manage/images/serverless-es-badge.svg)](https://www.elastic.co/docs/solutions/search)[![Observability](https://www.elastic.co/docs/deploy-manage/images/serverless-obs-badge.svg)](https://www.elastic.co/docs/solutions/observability)[![Security](https://www.elastic.co/docs/deploy-manage/images/serverless-sec-badge.svg)](https://www.elastic.co/docs/solutions/security) |
| Developer                   | Creates API keys, indices, data streams, adds connectors, and builds visualizations.                                                          | [![Elasticsearch](https://www.elastic.co/docs/deploy-manage/images/serverless-es-badge.svg)](https://www.elastic.co/docs/solutions/search)                                                                                                                                                                                                                                                                                           |
| Viewer                      | Has read-only access to project details, data, and features.                                                                                  | [![Elasticsearch](https://www.elastic.co/docs/deploy-manage/images/serverless-es-badge.svg)](https://www.elastic.co/docs/solutions/search)[![Observability](https://www.elastic.co/docs/deploy-manage/images/serverless-obs-badge.svg)](https://www.elastic.co/docs/solutions/observability)[![Security](https://www.elastic.co/docs/deploy-manage/images/serverless-sec-badge.svg)](https://www.elastic.co/docs/solutions/security) |
| Editor                      | Configures all Observability or Security projects. Has read-only access to data indices. Has full access to all project features.             | [![Observability](https://www.elastic.co/docs/deploy-manage/images/serverless-obs-badge.svg)](https://www.elastic.co/docs/solutions/observability)[![Security](https://www.elastic.co/docs/deploy-manage/images/serverless-sec-badge.svg)](https://www.elastic.co/docs/solutions/security)                                                                                                                                           |
| Tier 1 analyst              | Ideal for initial alert triage. General read access, can create dashboards and visualizations.                                                | [![Security](https://www.elastic.co/docs/deploy-manage/images/serverless-sec-badge.svg)](https://www.elastic.co/docs/solutions/security)                                                                                                                                                                                                                                                                                             |
| Tier 2 analyst              | Ideal for alert triage and beginning the investigation process. Can create cases.                                                             | [![Security](https://www.elastic.co/docs/deploy-manage/images/serverless-sec-badge.svg)](https://www.elastic.co/docs/solutions/security)                                                                                                                                                                                                                                                                                             |
| Tier 3 analyst              | Deeper investigation capabilities. Access to rules, lists, cases, Osquery, and response actions.                                              | [![Security](https://www.elastic.co/docs/deploy-manage/images/serverless-sec-badge.svg)](https://www.elastic.co/docs/solutions/security)                                                                                                                                                                                                                                                                                             |
| Threat intelligence analyst | Access to alerts, investigation tools, and intelligence pages.                                                                                | [![Security](https://www.elastic.co/docs/deploy-manage/images/serverless-sec-badge.svg)](https://www.elastic.co/docs/solutions/security)                                                                                                                                                                                                                                                                                             |
| Rule author                 | Access to detection engineering and rule creation. Can create rules from available data sources and add exceptions to reduce false positives. | [![Security](https://www.elastic.co/docs/deploy-manage/images/serverless-sec-badge.svg)](https://www.elastic.co/docs/solutions/security)                                                                                                                                                                                                                                                                                             |
| SOC manager                 | Access to alerts, cases, investigation tools, endpoint policy management, and response actions.                                               | [![Security](https://www.elastic.co/docs/deploy-manage/images/serverless-sec-badge.svg)](https://www.elastic.co/docs/solutions/security)                                                                                                                                                                                                                                                                                             |
| Endpoint operations analyst | Access to endpoint response actions. Can manage endpoint policies, Fleet, and integrations.                                                   | [![Security](https://www.elastic.co/docs/deploy-manage/images/serverless-sec-badge.svg)](https://www.elastic.co/docs/solutions/security)                                                                                                                                                                                                                                                                                             |
| Platform engineer           | Access to Fleet, integrations, endpoints, and detection content.                                                                              | [![Security](https://www.elastic.co/docs/deploy-manage/images/serverless-sec-badge.svg)](https://www.elastic.co/docs/solutions/security)                                                                                                                                                                                                                                                                                             |
| Detections admin            | All available detection engine permissions to include creating rule actions, such as notifications to third-party systems.                    | [![Security](https://www.elastic.co/docs/deploy-manage/images/serverless-sec-badge.svg)](https://www.elastic.co/docs/solutions/security)                                                                                                                                                                                                                                                                                             |
| Endpoint policy manager     | Access to endpoint policy management and related artifacts. Can manage Fleet and integrations.                                                | [![Security](https://www.elastic.co/docs/deploy-manage/images/serverless-sec-badge.svg)](https://www.elastic.co/docs/solutions/security)                                                                                                                                                                                                                                                                                             |


## Role scopes

Roles are assigned to every member of an organization and can refer (or be scoped) to one or more specific deployments, or all deployments. When a role is scoped to all deployments it grants permissions on all existing and future deployments.
This list describes the scope of the different roles:
- **Organization owner**: This role is always scoped to administer all deployments.
- **Billing admin**: This role does not refer to any deployment.
- **Cloud resource access roles**, including **Admin**: These roles can be scoped to either all deployments or projects, or specific deployments, project types, or projects.

Members are only able to see the role assignments of other members under the organization they belong to, for role assignments they are able to manage. Members with the **Organization owner** role assigned are able to see the role assignments of every member of their organization.
Members with the **Admin** role assigned are able to see role assignments for deployments or projects within their scope. For example, admins of all deployments and projects are able to see role assignments scoped to all and specific deployments and projects in the organization, while admins of specific deployments or projects only see role assignments scoped to those specific deployments or projects. This ensures that members assigned to specific deployments or projects do not try to remove role assignments from other members, and that the existence of other deployments or projects are not revealed to these members.