﻿---
title: Manage users
description: You can invite users to join your organization to allow them to interact with all or specific Elastic Cloud resources and settings. After they're invited,...
url: https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/manage-users
products:
  - Elastic Cloud Hosted
  - Elastic Cloud Serverless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
---

# Manage users
You can invite users to join your organization to allow them to interact with all or specific Elastic Cloud resources and settings. After they're invited, you can manage the users in your organization.
Alternatively, [configure Elastic Cloud SAML SSO](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/configure-saml-authentication) to enable your organization members to join the Elastic Cloud organization automatically.
<note>
  Users can only belong to one organization at a time. If a user that you want to invite already belongs to a different organization, that user first needs to leave their current organization, or to use a different email address. Check [Join an organization from an existing Elastic Cloud account](https://www.elastic.co/docs/cloud-account/join-or-leave-an-organization).
</note>

<tip>
  If you're using Elastic Cloud Hosted, then you can also manage users and control access [at the deployment level](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth).
</tip>


## Invite your team

To invite users to your organization:
1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
2. From a deployment or project on the home page, select **Manage**.
3. From the lower navigation menu, select **Organization**.
4. On the **Members** page, click **Invite members**.
5. Enter the email addresses of the users you want to invite in the textbox.
   To add multiple members, enter the member email addresses, separated by a space.
6. If desired, assign roles to the users so that they automatically get the appropriate permissions when they accept the invitation and sign in to Elastic Cloud.
   If you're assigning roles for Elastic Cloud Serverless projects, then you can grant access to all projects of the same type with a unique role, or select individual roles for specific projects. For more details about roles, refer to [User roles and privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/user-roles).
7. Click **Send invites**.
   Invitations to join an organization are sent by email. Invited users have 72 hours to accept the invitation before it expires. If the invite has expired, an admin can resend the invitation.


## Manage existing users

On the **Members** tab of the **Organization** page, you can view the list of current members, including status and role.
In the **Actions** column, click the three dots to edit a member’s role, or revoke an invite, or remove a member from your organization.

## Manage users through the Elastic Cloud API

You can also manage members of your organization using the [Elastic Cloud API](https://www.elastic.co/docs/api/doc/cloud/).
<dropdown title="Get information about your organization">
  Get information about your Elastic Cloud organization.
  ```sh
  curl -XGET \
  -H "Authorization: ApiKey $EC_API_KEY" \
  "https://api.elastic-cloud.com/api/v1/organizations"
  ```
</dropdown>

<dropdown title="Invite members to your organization">
  Invite members to your Elastic Cloud organization.
  ```sh
  curl -XPOST \
  -H 'Content-Type: application/json' \
  -H "Authorization: ApiKey $EC_API_KEY" \
  "https://api.elastic-cloud.com/api/v1/organizations/$ORGANIZATION_ID/invitations" \
  -d '
  {
    "emails": [
      "test@test.com" 
    ]
  }'
  ```
</dropdown>

<dropdown title="View pending invitations to your organization">
  View pending invitations to your Elastic Cloud organization.
  ```sh
  curl -XGET \
  -H 'Content-Type: application/json' \
  -H "Authorization: ApiKey $EC_API_KEY" \
  "https://api.elastic-cloud.com/api/v1/organizations/$ORGANIZATION_ID/invitations"
  ```

  <dropdown title="View members in your organization">
    View members in your Elastic Cloud organization.
    ```sh
    curl -XGET \
    -H "Authorization: ApiKey $EC_API_KEY" \
    "https://api.elastic-cloud.com/api/v1/organizations/$ORGANIZATION_ID/members"
    ```
  </dropdown>
</dropdown>

<dropdown title="Remove members from your organization">
  Remove members from your Elastic Cloud organization.
  ```sh
  curl -XDELETE \
  -H "Authorization: ApiKey $EC_API_KEY" \
  "https://api.elastic-cloud.com/api/v1/organizations/$ORGANIZATION_ID/members/$USER_IDS"
  ```
  `USER_IDS`  One or more comma-delimited user ids to remove from the organization
</dropdown>