﻿---
title: Cloud organization users
description: When you sign up to Elastic Cloud, you create an organization. This organization is the umbrella for all of your Elastic Cloud resources, users, and account...
url: https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
---

# Cloud organization users
When you sign up to Elastic Cloud, you create an organization. This organization is the umbrella for all of your Elastic Cloud resources, users, and account settings. Every organization has a unique identifier.
You can perform the following tasks to control access to your Cloud organization, your Elastic Cloud Hosted deployments, and your Elastic Cloud Serverless projects:
- [Manage users](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/manage-users): Invite users to join your organization and manage existing users.
- Assign [user roles and privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/user-roles):
  - Manage organization-level roles and high-level access to deployments and projects.
- If you have Elastic Cloud Serverless projects, assign project-level roles and create custom roles.
- Configure [SAML single sign-on](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/configure-saml-authentication) for your organization.

<tip>
  If you're using Elastic Cloud Hosted, then you can also manage users and control access [at the deployment level](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth).
</tip>


## Should I use organization-level or deployment-level SSO?

<applies-to>
  - Elastic Cloud Hosted: Generally available
</applies-to>

For Elastic Cloud Hosted deployments, you can configure SSO at the [organization level](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/configure-saml-authentication), the [deployment level](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth), or both.
The option that you choose depends on your requirements:

| Consideration                | Organization-level                                                                                                                                                                                                                                                | Deployment-level                                                                                                                                                                                      |
|------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **Management experience**    | Manage authentication and role mapping centrally for all deployments in the organization                                                                                                                                                                          | Configure SSO for each deployment individually                                                                                                                                                        |
| **Authentication protocols** | SAML only                                                                                                                                                                                                                                                         | Multiple protocols, including LDAP, OIDC, and SAML                                                                                                                                                    |
| **Role mapping**             | [Organization-level roles and cloud resource access roles](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/user-roles), Serverless project [custom roles](https://www.elastic.co/docs/deploy-manage/users-roles/serverless-custom-roles) | [Built-in](https://www.elastic.co/docs/reference/elasticsearch/roles) and [custom](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/defining-roles) stack-level roles |
| **User experience**          | Users interact with Cloud                                                                                                                                                                                                                                         | Users interact with the deployment directly                                                                                                                                                           |

If you want to avoid exposing users to the Elastic Cloud Console, or have users who only interact with some deployments, then you might prefer users to interact with your deployment directly.
In some circumstances, you might want to use both organization-level and deployment-level SSO. For example, if you have a data analyst who interacts only with data in specific deployments, then you might want to configure deployment-level SSO for them. If you manage multiple tenants in a single organization, then you might want to configure organization-level SSO to administer deployments, and deployment-level SSO for the users who are using each deployment.