﻿---
title: Manage users and roles
description: Role-based access control (RBAC) provides a way to add multiple users and restrict their access to specific platform resources. In addition to the system...
url: https://www.elastic.co/docs/deploy-manage/users-roles/cloud-enterprise-orchestrator/manage-users-roles
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Manage users and roles
Role-based access control (RBAC) provides a way to add multiple users and restrict their access to specific platform resources. In addition to the system `admin` and `readonly` users, you can create additional users and assign pre-built roles to control access to platform operations, deployment assets, or API calls.
Implementing RBAC in your environment benefits you in several ways:
- Streamlines the process of assigning or updating privileges for users as a group, instead of painstakingly managing individual users.
- Limits access to just what’s needed for that user’s job function, isolating company assets.
- Assists with compliance to security and data standards or laws.
- Adds multiple users by:
  - Creating [native users](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-enterprise-orchestrator/native-user-authentication) locally.
- Integrating with third-party authentication providers like [Active Directory](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-enterprise-orchestrator/active-directory), [LDAP](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-enterprise-orchestrator/ldap) or [SAML](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-enterprise-orchestrator/saml).

<tip>
  This topic describes implementing RBAC at the Elastic Cloud Enterprise installation level, which can be used to access the Cloud UI, and which can be set up to provide SSO capabilities to access deployments orchestrated by your Elastic Cloud Enterprise installation.If you want to manage access to each deployment individually, then refer to [Cluster or deployment users](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth).
</tip>

<important>
  With RBAC, interacting with API endpoints now requires a [bearer token](https://www.elastic.co/docs/reference/cloud/cloud-enterprise/ece-api-command-line) or [API key](/docs/deploy-manage/api-keys/elastic-cloud-enterprise-api-keys#ece-api-keys).
</important>


## Before you begin

To prepare for RBAC, you should review the Elastic Cloud Enterprise [limitations and known issues](https://www.elastic.co/docs/release-notes/cloud-enterprise/known-issues).

## Available roles and permissions

Beyond the system users, there are several pre-built roles that you can apply to additional users:
<definitions>
  <definition term="Platform admin">
    Same access as the `admin` system user.
  </definition>
  <definition term="Platform viewer">
    Same access as the `readonly` system user, which includes being able to view secret and sensitive settings.
  </definition>
  <definition term="Deployment manager">
    Can create and manage non-system deployments, specify keystore security settings, and establish cross-cluster remote relationships. They can also reset the `elastic` password.
  </definition>
  <definition term="Deployment viewer">
    Can view non-system deployments, including their activity. Can prepare the diagnostic bundle, inspect the files, and download the bundle as a ZIP file.
  </definition>
</definitions>


## Step 1: Configure the security deployment

The security deployment is a system deployment that manages all of the Elastic Cloud Enterprise authentication and permissions. It is created automatically during installation.
<important>
  We strongly recommend using three availability zones with at least 1 GB Elasticsearch nodes. You can scale up if you expect a heavy authentication workload.
</important>

1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
2. Go to **Deployments** a select the **security-cluster**.
3. Configure regular [snapshots](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/create-snapshots) of the security deployment. This is critical if you plan to create any native users.
4. Optional: [Enable monitoring](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring/ece-ech-stack-monitoring) on the security deployment to a dedicated monitoring deployment.

If you have authentication issues, you check out the security deployment Elasticsearch [logs](https://www.elastic.co/docs/deploy-manage/monitor/logging-configuration).

## Step 2: Set up provider profiles

Configure any third-party authentication providers that you want to use.
If you want to use only [native user authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-enterprise-orchestrator/native-user-authentication), then no additional configuration is required.
- [Active Directory](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-enterprise-orchestrator/active-directory)
- [LDAP](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-enterprise-orchestrator/ldap)
- [SAML](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-enterprise-orchestrator/saml)

During setup, you can map users according to their properties to Elastic Cloud Enterprise roles.

## Step 3: Change the order of provider profiles

Elastic Cloud Enterprise performs authentication checks against the configured providers, in order. When a match is found, the user search stops. The roles specified by that first profile match dictate which permissions the user is granted—regardless of what permissions might be available in another, lower-order profile.
To change the provider order:
1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
2. Go to **Users** and then **Authentication providers**.
3. Use the carets to update the provider order.

Changing the order is a configuration change and you can’t make changes to other providers until it is complete.

## Change the user settings

Platform admins and users can access user settings. Full name, contact email, and updating the password can be changed by either. The username cannot be changed. The platform admin can also assign roles and disable users.
- For platform admins, the user settings are editable from the **Users** page.
- For users, they can edit their profile from the **Settings** page.