﻿---
title: Upgrade Assistant
description: The Upgrade Assistant helps you prepare to upgrade to the next major version of the Elastic Stack. To access the assistant, go to the Upgrade Assistant...
url: https://www.elastic.co/docs/deploy-manage/upgrade/prepare-to-upgrade/upgrade-assistant
products:
  - Elastic Cloud Enterprise
  - Elastic Cloud Hosted
  - Elastic Cloud on Kubernetes
  - Elasticsearch
  - Kibana
applies_to:
  - Elastic Stack: Generally available
---

# Upgrade Assistant
The Upgrade Assistant helps you [prepare to upgrade](https://www.elastic.co/docs/deploy-manage/upgrade/prepare-to-upgrade) to the next major version of the Elastic Stack.
To access the assistant, go to the **Upgrade Assistant** management page in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
<tip>
  Upgrade assistant should be run from the latest minor release before a major upgrade. When upgrading to 9.x, ensure you run 8.19.latest, and run the assistant there.
  Running the latest patched version of 8.19 will apply latest version of the upgrade assistant logic.
</tip>

The assistant identifies deprecated settings in your configuration, and if any of those settings are enabled, it guides you through resolving issues that could prevent a successful upgrade. The Upgrade Assistant also helps resolve issues with older indices created before version 8.0.0, providing options to reindex older indices or mark them as read-only.

## Required permissions

To access the Upgrade Assistant, you need the `manage` cluster privilege.
Reindexing indices requires "all" access for both the existing and target index. In versions 8.18.0 through 8.18.8 and 8.19.0 through 8.19.5, the `superuser` role is required.
You may also need additional privileges to perform specific actions.

## Feature set

Some features of the Upgrade Assistant are only needed when upgrading to a new major version. The features enabled by default are those for the next version from the one Kibana currently runs on.

## Deprecations

The Upgrade Assistant pulls information about deprecations from the following sources:
- Elasticsearch deprecation info API
- Elasticsearch deprecation logs
- Kibana deprecations API

For more information about Upgrade Assistant APIs, refer to [Upgrade Assistant APIs](https://www.elastic.co/docs/api/doc/kibana/group/endpoint-upgrade).