﻿---
title: Upgrade your deployment on Elastic Cloud on Kubernetes (ECK)
description: The ECK orchestrator can safely perform upgrades to newer versions of the Elastic Stack. Before you start the upgrade, plan your upgrade, take the upgrade...
url: https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/upgrade-on-eck
products:
  - Elastic Cloud on Kubernetes
  - Elasticsearch
  - Kibana
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Upgrade your deployment on Elastic Cloud on Kubernetes (ECK)
The ECK orchestrator can safely perform upgrades to newer versions of the Elastic Stack.
Before you start the upgrade, [plan your upgrade](https://www.elastic.co/docs/deploy-manage/upgrade/plan-upgrade), [take the upgrade preparation steps](https://www.elastic.co/docs/deploy-manage/upgrade/prepare-to-upgrade), and ensure your ECK version is [compatible](/docs/deploy-manage/deploy/cloud-on-k8s#stack-compatibility) with the Elastic Stack version you’re upgrading to. If it's incompatible, [upgrade your orchestrator](https://www.elastic.co/docs/deploy-manage/upgrade/orchestrator/upgrade-cloud-on-k8s) first.

## How ECK manages upgrades

ECK ensures that Elastic Stack components are upgraded in the correct order. Upgrades to dependent resources are delayed until that dependency is upgraded. For example, the Kibana upgrade starts only when the associated Elasticsearch cluster has been upgraded.
Check out [Nodes orchestration](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/nodes-orchestration) for more information on how ECK manages upgrades and how to tune its behavior.

## Perform the upgrade

The upgrade procedure depends on whether you are deploying the Elastic Stack components [using resource manifests](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/elasticsearch-deployment-quickstart) or the [Elastic Stack Helm chart](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/managing-deployments-using-helm-chart).

### Upgrade using resource manifests

1. In the resource spec file, modify the `version` field for the desired Elastic Stack version.
2. Save your changes. The orchestrator will start the upgrade process automatically.

In this example, we're upgrading Elasticsearch and Kibana to 9.3.0 by changing the `spec.version` field in each component.
<dropdown title="Example manifest">
  <important>
    For production use, for Elastic Stack version 8.16 and later, set the `vm.max_map_count` kernel setting to `1048576`; for Elastic Stack version 8.15 and earlier, set `vm.max_map_count` to `262144`. Refer to [Virtual memory](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/virtual-memory) for more information.
  </important>

  ```yaml
  apiVersion: elasticsearch.k8s.elastic.co/v1
  kind: Elasticsearch
  metadata:
    name: elasticsearch-sample
    namespace: production
  spec:
    version: 9.3.0
    monitoring:
      metrics:
        elasticsearchRefs:
          - name: monitoring-cluster
            namespace: observability
      logs:
        elasticsearchRefs:
          - name: monitoring-cluster
            namespace: observability
    http:
      service:
        spec:
          type: LoadBalancer
    nodeSets:
    - name: master
      count: 3
      config:
        node.roles: ["master"]
        xpack.ml.enabled: true
        node.store.allow_mmap: false
      volumeClaimTemplates:
      - metadata:
          name: elasticsearch-data
        spec:
          accessModes:
          - ReadWriteOnce
          resources:
            requests:
              storage: 20Gi
          storageClassName: standard
      podTemplate:
        metadata:
          labels:
            key: sample
        spec:
          initContainers:
          - name: sysctl
            securityContext:
              privileged: true
            command: ['sh', '-c', 'sysctl -w vm.max_map_count=1048576']
          containers:
          - name: elasticsearch
            resources:
              requests:
                memory: 2Gi
                cpu: 0.5
              limits:
                memory: 2Gi
                cpu: 1
    - name: data
      count: 3
      config:
        node.roles: ["data", "ingest", "ml", "transform"]
        node.store.allow_mmap: false
      volumeClaimTemplates:
      - metadata:
          name: elasticsearch-data
        spec:
          accessModes:
          - ReadWriteOnce
          resources:
            requests:
              storage: 20Gi
          storageClassName: standard
      podTemplate:
        metadata:
          labels:
            key: sample
        spec:
          initContainers:
          - name: sysctl
            securityContext:
              privileged: true
            command: ['sh', '-c', 'sysctl -w vm.max_map_count=1048576']
          containers:
          - name: elasticsearch
            resources:
              requests:
                memory: 2Gi
                cpu: 0.5
              limits:
                memory: 2Gi
                cpu: 1
  ---
  apiVersion: kibana.k8s.elastic.co/v1
  kind: Kibana
  metadata:
    name: kibana-sample
    namespace: production
  spec:
    version: 9.3.0
    monitoring:
      metrics:
        elasticsearchRefs:
          - name: monitoring-cluster
            namespace: observability
      logs:
        elasticsearchRefs:
          - name: monitoring-cluster
            namespace: observability
    http:
      service:
        spec:
          type: LoadBalancer
    count: 1
    elasticsearchRef:
      name: elasticsearch-sample
  ```
</dropdown>


### Upgrade using Helm charts

If you deploy your Elastic Stack resources using our Helm chart, refer to [managing deployments using Helm chart](/docs/deploy-manage/deploy/cloud-on-k8s/managing-deployments-using-helm-chart#k8s-upgrade-modify-helm) for details on how to perform upgrades with Helm.

## Archived settings

If you upgrade an Elasticsearch cluster that uses deprecated cluster or index settings that are not used in the target version, they are archived. You should remove any archived settings after upgrading. For more information, refer to [Archived settings](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/archived-settings).

## Next steps

Once you've successfully upgraded your deployment, you can [upgrade your ingest components](https://www.elastic.co/docs/deploy-manage/upgrade/ingest-components), such as Logstash, Elastic Agents, or Beats.