﻿---
title: Upgrade on Elastic Cloud Hosted (ECH)
description: Once you are prepared to upgrade, a single click in the Elastic Cloud console can upgrade a deployment to a newer version, add more processing capacity,...
url: https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/upgrade-on-ech
products:
  - Elastic Cloud Hosted
  - Elasticsearch
  - Kibana
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Upgrade on Elastic Cloud Hosted (ECH)
Once you are [prepared to upgrade](https://www.elastic.co/docs/deploy-manage/upgrade/prepare-to-upgrade), a single click in the Elastic Cloud console can upgrade a deployment to a newer version, add more processing capacity, change plugins, and enable or disable high availability, all at the same time. During the upgrade process, Elasticsearch, Kibana, Elastic APM, and all of your deployment components are upgraded simultaneously.
Elastic Cloud only supports and enables upgrades to released versions that comply with the supported [upgrade paths](/docs/deploy-manage/upgrade#upgrade-paths). Release candidate builds and master snapshots are not supported.
<important>
  Although it’s simple to upgrade an Elastic Cloud deployment, the new version might include breaking changes that affect your application. Ensure you review breaking changes and deprecation logs, make any necessary changes, and test against the new version before upgrading your production deployment.
</important>


## Availability during upgrades

For deployments with nodes in more than one availability zone, you can perform upgrades and cluster configuration changes with no downtime. Deployments with nodes in only one zone might experience downtime during these operations.
When Kibana instances are upgraded, all instances are shut down simultaneously, making Kibana temporarily inaccessible, even if it's deployed across multiple zones.
If your indices are not highly available (configured with at least one replica), or if certain components of your deployment run in only one zone, you might experience availability issues for requests that depend on that specific data or component, while the affected nodes are being restarted.
Refer to [Plan for production](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/elastic-cloud-hosted-planning) for more information about High Availability (HA) on ECH.

## Perform the upgrade

Log in to your Elastic Cloud environment:
1. Log in to the [Elastic Cloud Hosted console](https://cloud.elastic.co/login).
2. Select your deployment on the home page in the Elastic Cloud Hosted card or go to the **Hosted deployments** page.
   Narrow your deployments by name, ID, or choose from several other filters. To customize your view, use a combination of filters, or change the format from a grid to a list.

To upgrade a deployment:
1. In the **Deployment version** section, click **Upgrade**.
2. Select the appropriate version you're upgrading to.
3. Click **Upgrade**, then **Confirm upgrade**. The new configuration takes a few minutes to create.
   <note>
   If any incompatibilities are detected when you attempt to upgrade, the UI provides a link to the Upgrade Assistant, which checks for deprecated settings in your cluster and indices and helps you resolve them. If there are any issues that would prevent a successful upgrade, the upgrade is blocked. After resolving the issues, return to the **Hosted deployments** page and restart the upgrade. Also check the [release notes](https://www.elastic.co/docs/release-notes) to stay aware of changes and known issues for the version you're upgrading to.
   </note>

<definitions>
  <definition term="Snapshots">
    To keep your data safe during the upgrade process, a snapshot is taken automatically before any changes are made to your cluster. After a major version upgrade is complete and a snapshot of the upgraded cluster is available, all snapshots taken with the previous major version of Elasticsearch are stored in the snapshot repository.
  </definition>
  <definition term="Security realm settings">
    During the upgrade process, you are prompted to update the security realm settings if your user settings include a `xpack.security.authc.realms` value.
    If the security realms are configured in `user_settings`, you’ll be prompted to modify the settings:
    1. On the **Update security realm settings** window, edit the settings.
    2. Click **Update settings**. If the security realm settings are located in `user_settings_override`, contact support to help you upgrade.
  </definition>
</definitions>


## Archived settings

If you upgrade an Elasticsearch cluster that uses deprecated cluster or index settings that are not used in the target version, they are archived. You should remove any archived settings after upgrading. For more information, refer to [Archived settings](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/archived-settings).

## Next steps

Once you've successfully upgraded on Elastic Cloud Hosted, [upgrade your ingest components](https://www.elastic.co/docs/deploy-manage/upgrade/ingest-components), such as Logstash, Elastic Agents, or Beats.