﻿---
title: Upgrade your deployment on Elastic Cloud Enterprise (ECE)
description: A single click in the Elastic Cloud console can upgrade a deployment running on ECE to a newer version, add more processing capacity, change plugins,...
url: https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/upgrade-on-ece
products:
  - Elastic Cloud Enterprise
  - Elasticsearch
  - Kibana
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Upgrade your deployment on Elastic Cloud Enterprise (ECE)
A single click in the Elastic Cloud console can upgrade a deployment running on ECE to a newer version, add more processing capacity, change plugins, and enable or disable high availability, all at the same time. During the upgrade process, Elasticsearch, Kibana, Elastic APM, and all of your deployment components are upgraded simultaneously.
Once you're [prepared to upgrade](https://www.elastic.co/docs/deploy-manage/upgrade/prepare-to-upgrade), do the following:
1. Ensure your current ECE and Docker or Podman versions are [compatible](https://www.elastic.co/support/matrix/#elastic-cloud-enterprise) with the Elastic Stack version you're upgrading to. For example, if you're upgrading to 9.0.0, the minimum required version is ECE 4.0. If you don’t have a compatible version installed, [upgrade your orchestrator](https://www.elastic.co/docs/deploy-manage/upgrade/orchestrator/upgrade-cloud-enterprise).
2. Download the most recent [stack pack](/docs/deploy-manage/deploy/cloud-enterprise/manage-elastic-stack-versions#ece_most_recent_elastic_stack_packs) for the version you’re upgrading to, then [add the stack pack](/docs/deploy-manage/deploy/cloud-enterprise/manage-elastic-stack-versions#ece-manage-elastic-stack-add) to your ECE installation using the Cloud UI.
3. If not configured already, [assign a snapshots repository](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/cloud-enterprise) to your deployment to enable snapshots and back up your data. Although this is optional, we recommend this step.


## Perform the upgrade

1. [Log in to the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
2. On the **Deployments** page, select your deployment.
   Narrow the list by name, ID, or choose from several other filters. To further define the list, use a combination of filters.
3. In the **Deployment version** section, click **Upgrade**.
4. Select the version you're upgrading to. For example, `9.0.0`.
5. Click **Upgrade**, then **Confirm upgrade**. The new configuration takes a few minutes to create.
   <note>
   If any incompatibilities are detected when you attempt to upgrade, the UI provides a link to the Upgrade Assistant, which checks for deprecated settings in your cluster and indices and helps you resolve them. If there are any issues that would prevent a successful upgrade, the upgrade is blocked. After resolving the issues, return to the **Deployments** page and restart the upgrade. Also check the [release notes](https://www.elastic.co/docs/release-notes) to stay aware of changes and known issues for the version you're upgrading to.
   </note>

**Security realm settings**
During the upgrade process, you are prompted to update the security realm settings if your user settings include a `xpack.security.authc.realms` value.
If the security realms are configured in `user_settings`, you’ll be prompted to modify the settings:
1. On the **Update security realm settings** window, edit the settings.
2. Click **Update settings**. If the security realm settings are located in `user_settings_override`, contact support to help you upgrade.


## Archived settings

If you upgrade an Elasticsearch cluster that uses deprecated cluster or index settings that are not used in the target version, they are archived. You should remove any archived settings after upgrading. For more information, refer to [Archived settings](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/archived-settings).

## Next steps

Once you've successfully upgraded your deployment, [upgrade your ingest components](https://www.elastic.co/docs/deploy-manage/upgrade/ingest-components), such as Logstash, Elastic Agents, or Beats.