﻿---
title: Upgrade from 7.17 to 9.3.0
description: Elastic Stack version 7.17 has a defined end of support date of 15 January 2026, as stated in the Elastic Product & Version End of Life Policy. This document...
url: https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/upgrade-717
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Generally available
---

# Upgrade from 7.17 to 9.3.0
Elastic Stack version 7.17 has a defined end of support date of 15 January 2026, as stated in the [Elastic Product & Version End of Life Policy](https://www.elastic.co/support/eol). This document provides a guided plan to upgrade from 7.17 to the latest 9.3.0 release. It complements the official upgrade documentation by showing how the different pieces fit together in a complete upgrade exercise.
This guide applies to all clusters running Elastic Stack version **7.17.x** across all deployment types, including Elastic Cloud Hosted (ECH), Elastic Cloud Enterprise (ECE), or Elastic Cloud on Kubernetes (ECK) deployments and completely self-managed clusters. If you are using an earlier version, [upgrade first to the latest 7.17 release](https://www.elastic.co/guide/en/elastic-stack/7.17/upgrading-elastic-stack.html) before proceeding.

## Overview

Upgrading from 7.17 to 9.3.0 requires two major upgrades. Each major upgrade must be prepared and executed independently, although the planning phase can be shared.
1. **7.17.x → 8.19.x**
   This brings the cluster onto the latest supported 8.x release, which is the required intermediate version before upgrading to 9.3.0.
   Before running this upgrade, all ingest components and client libraries must be upgraded to 7.17.x.
2. **8.19.x → 9.3.0**
   This completes the upgrade to the latest 9.x release.
   Before running this upgrade, all ingest components and client libraries must be upgraded to 8.19.x.

<note>
  Upgrading only as far as Elastic Stack 8.19.x is also a supported path, as 8.19.x remains a maintained and fully supported release. However, we recommend completing the upgrade to the latest version, 9.3.0, to take advantage of ongoing improvements and new features.
</note>

The following sections describe these phases in detail and point to the relevant documentation for each deployment type.
Refer to [upgrade paths](/docs/deploy-manage/upgrade#upgrade-paths) for more information.
<dropdown title="Alternative method: Reindex to upgrade">
  For basic use cases that do not rely on Kibana dashboards or Elastic Stack features such as machine learning, transforms, Kibana alerting, or detection rules, instead of performing two sequential upgrades (7.17 → 8.19 → 9.3.0), you can create a new 9.3.0 cluster or deployment and migrate your data from the 7.17 cluster by reindexing.For detailed guidance on how to plan and execute this method, refer to [Reindex to upgrade](/docs/deploy-manage/upgrade/prepare-to-upgrade#reindex-to-upgrade).It may be suitable when:
  - You prefer to build new infrastructure rather than modify an existing one.
  - You want to reduce the risk of performing two consecutive major upgrades.
  - You plan to redesign your topology or move to a new environment, for example from self-managed to Elastic Cloud Hosted or Elastic Cloud Enterprise.
  This approach is intended for Elasticsearch use cases focused on indexing and querying your own data. If you need to preserve Kibana configurations and Elastic Stack feature data, follow the standard upgrade path instead.
</dropdown>


## Upgrade planning

The [planning phase](https://www.elastic.co/docs/deploy-manage/upgrade/plan-upgrade) ensures that the upgrade is well understood, can be executed with minimal risk, and follows the [correct order](/docs/deploy-manage/upgrade/plan-upgrade#upgrade-order).
It involves defining a clear sequence of actions and assessing the impact on [service availability](/docs/deploy-manage/upgrade#availability-during-upgrades) and performance during the upgrade.
For the 7.17.x → 9.x upgrade path, the main planning outcome is a set of required actions to ensure compatibility across the environment:
- **Ingest components:**
  Before the initial upgrade to 8.19.x, ensure that all ingest components (Beats, Elastic Agent, Logstash, APM) are on version 7.17.x. If you are using an earlier version of any of these components, refer to the following docs to upgrade your components before proceeding:
  <dropdown title="7.17 Elastic Stack ingest components">
  - Beats: [Upgrade instructions](https://www.elastic.co/guide/en/beats/libbeat/7.17/upgrading.html)
  - Logstash: [Upgrade instructions](https://www.elastic.co/guide/en/logstash/7.17/upgrading-logstash.html)
  - Fleet managed Elastic Agent: [Upgrade instructions](https://www.elastic.co/guide/en/fleet/7.17/upgrade-elastic-agent.html)
  - Standalone Elastic Agent: [Upgrade instructions](https://www.elastic.co/guide/en/fleet/7.17/upgrade-standalone.html)
  - Elastic APM: [Upgrade instructions](https://www.elastic.co/guide/en/apm/guide/7.17/upgrade.html)
  </dropdown>
  After upgrading the cluster to 8.19.x and before proceeding to 9.3.0, upgrade all ingest components to 8.19.x. This step will be covered later in this guide.
- **Client libraries:**
  If you use custom-developed applications that rely on [Elasticsearch client libraries](https://www.elastic.co/docs/reference/elasticsearch-clients), make sure to include them in your plan. Client libraries must be upgraded after each major Elasticsearch upgrade to ensure support and compatibility.
  Applications that use deprecated or removed APIs might require code updates, or you can use the [REST API compatibility](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/compatibility) feature to maintain compatibility with the next major version.
  This topic will be revisited in more detail during the preparation steps for each major upgrade.
- **Orchestration platforms:**
  - **ECK**: If you are running an ECK version earlier than 3.x, you need to [upgrade ECK to 3.x](https://www.elastic.co/docs/deploy-manage/upgrade/orchestrator/upgrade-cloud-on-k8s) before the final upgrade to 9.x. This can be done either at the beginning, before the initial upgrade, or between the two upgrade phases.
- **ECE**: If you are running an ECE version earlier than 4.x, you need to [upgrade your ECE platform to 4.x](https://www.elastic.co/docs/deploy-manage/upgrade/orchestrator/upgrade-cloud-enterprise) before the final upgrade to 9.x. This upgrade must be performed after upgrading your deployments to 8.19.x, because ECE 4.x is not compatible with 7.x deployments.

Finally, we strongly recommend [testing the full upgrade process in a non-production environment](/docs/deploy-manage/upgrade/plan-upgrade#test-in-a-non-production-environment) before applying it to production.

## Upgrade step 1: 7.17.x → 8.19.x

This step covers upgrading your deployment from 7.17.x to 8.19.x, following the [planning phase](#planning) and assuming that all ingest components and client libraries are compatible with 8.19.x.
It's highly recommended to start this upgrade from the latest 7.17.x patch release to ensure that you’re using the most recent version of the Elastic Upgrade Assistant. You should also upgrade to the latest available 8.19.x patch release so that the same benefits apply when you later upgrade to 9.x.
<warning>
  If you use the [Elastic Security solution](https://www.elastic.co/docs/solutions/security), then you need to perform additional steps as part of the upgrade process. Review [Upgrade Elastic Security from 7.17 to 8.x](https://www.elastic.co/guide/en/security/8.19/upgrade-7.17-8x.html) before you begin your upgrade.In particular:
  - Export all custom detection rules as a backup before upgrading, in case there are issues with the detection engine after the upgrade.
  - Review [alert schema changes](https://www.elastic.co/guide/en/security/8.19/alert-schema.html) if alerts are forwarded to an external SOAR, or if you directly query alert data in custom dashboards or visualizations.
  - Plan for the [post-upgrade steps](https://www.elastic.co/guide/en/security/8.19/upgrade-7.17-8x.html#_post_upgrade_steps), such as re-enabling and verifying rules after the upgrade.
</warning>


### 8.19 upgrade preparations

The [upgrade preparation steps from 7.x](https://www.elastic.co/guide/en/elastic-stack/8.19/upgrading-elastic-stack.html#prepare-to-upgrade) are designed to prevent upgrade failures by detecting and addressing internal incompatibilities, including deprecated settings that are no longer supported in the next release.
During a major upgrade, the [Upgrade Assistant](https://www.elastic.co/guide/en/kibana/7.17/upgrade-assistant.html) in Kibana 7.17 plays a critical role. It scans your cluster for deprecated settings, incompatible indices, and other issues that could prevent nodes from starting after the upgrade. The tool guides you through reindexing old indices, fixing configuration problems, and reviewing deprecation logs to ensure your deployment is fully compatible with the next major version. Ignoring its recommendations can lead to upgrade failures or cluster downtime.
While the Upgrade Assistant helps you identify breaking changes that affect your deployment or cluster, it's still recommended to review the complete list of breaking changes and known issues in every release from your current version through your target version as part of the preparation phase. These are available in the following documents:
- [Elasticsearch 8.x migration guide](https://www.elastic.co/guide/en/elasticsearch/reference/8.19/breaking-changes.html)
- [Kibana breaking changes summary](https://www.elastic.co/guide/en/kibana/8.19/breaking-changes-summary.html)

Follow the guidelines below for your specific deployment type:
<applies-switch>
  <applies-item title="ess:" applies-to="Elastic Cloud Hosted: Generally available">
    The Elastic Cloud platform facilitates major upgrades by doing the following:
    - Automatically creating a snapshot before the upgrade.
    - Detecting deprecated settings and index compatibility issues.
    - Blocking the upgrade until all issues are resolved through the Upgrade Assistant, ensuring a reliable outcome.
    To prepare your deployment for the upgrade, complete the steps described in the [8.19 Elastic Cloud upgrade guide](https://www.elastic.co/guide/en/elastic-stack/8.19/upgrade-elastic-stack-for-elastic-cloud.html) up to the "Perform the upgrade" section.You should make sure to:
    1. Run the Upgrade Assistant in Kibana and resolve all critical issues before continuing. The assistant helps you:
       - Reindex legacy indices (created before 7.0).
    - Remove or update deprecated settings and mappings.
    - Review deprecation logs for both Elasticsearch and Kibana.
    2. If you use [custom plugins or bundles](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/upload-custom-plugins-bundles), make sure they're compatible with the next major release.
    3. If you use custom-developed applications that are impacted by API-related breaking changes, make the recommended changes to ensure that your applications continue to operate as expected after the upgrade, or, as a temporary solution, you can use [REST API compatibility mode](https://www.elastic.co/guide/en/elasticsearch/reference/8.19/rest-api-compatibility.html) to submit requests to 8.x using the 7.x syntax.
       <note>
       The REST API compatibility mode should only serve as a bridge to ease the upgrade process, not as a long-term strategy. For a high-level description of the steps to ensure a smooth upgrade involving client applications that use this mode, refer to the [REST API compatibility workflow example](https://www.elastic.co/guide/en/elasticsearch/reference/8.19/rest-api-compatibility.html#_rest_api_compatibility_workflow).
       </note>
  </applies-item>

  <applies-item title="ece:" applies-to="Elastic Cloud Enterprise: Generally available">
    Elastic Cloud Enterprise platform facilitates major upgrades by doing the following:
    - When [snapshots are configured](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/cloud-enterprise), automatically creating a snapshot before the upgrade.
    - Detecting deprecated settings and index compatibility issues.
    - Blocking the upgrade until all issues are resolved through the Upgrade Assistant, ensuring a reliable outcome.
    To prepare your deployment for the upgrade, complete the steps described in the [8.19 Elastic Cloud upgrade guide](https://www.elastic.co/guide/en/elastic-stack/8.19/upgrade-elastic-stack-for-elastic-cloud.html) up to the "Perform the upgrade" section.
    <note>
      Although this guide refers to Elastic Cloud, the same preparation steps apply to ECE deployments.
    </note>
    You should make sure to:
    1. Run the Upgrade Assistant in Kibana and resolve all critical issues before continuing. The assistant helps you:
       - Reindex legacy indices (created before 7.0).
    - Remove or update deprecated settings and mappings.
    - Review deprecation logs for both Elasticsearch and Kibana.
    2. If you use [custom plugins or bundles](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/upload-custom-plugins-bundles), make sure they're compatible with the next major release.
    3. If you use custom-developed applications that are impacted by API-related breaking changes, make the recommended changes to ensure that your applications continue to operate as expected after the upgrade, or, as a temporary solution, you can use [REST API compatibility mode](https://www.elastic.co/guide/en/elasticsearch/reference/8.19/rest-api-compatibility.html) to submit requests to 8.x using the 7.x syntax.
       <note>
       The REST API compatibility mode should only serve as a bridge to ease the upgrade process, not as a long-term strategy. For a high-level description of the steps to ensure a smooth upgrade involving client applications that use this mode, refer to the [REST API compatibility workflow example](https://www.elastic.co/guide/en/elasticsearch/reference/8.19/rest-api-compatibility.html#_rest_api_compatibility_workflow).
       </note>
  </applies-item>

  <applies-item title="eck:" applies-to="Elastic Cloud on Kubernetes: Generally available">
    Upgrade preparations for an Elastic Cloud on Kubernetes-managed cluster are similar to a self-managed deployment. Before starting the upgrade:
    - Follow the steps in [Prepare to upgrade from 7.x](https://www.elastic.co/guide/en/elastic-stack/8.19/upgrading-elastic-stack.html#prepare-to-upgrade).
    - Review the [Elasticsearch upgrade setup guide](https://www.elastic.co/guide/en/elasticsearch/reference/8.19/setup-upgrade.html) for additional details and best practices.
    As part of your preparation, make sure to complete all tasks reported by the Upgrade Assistant, review any installed plugins for compatibility, and check whether custom client applications are affected by API-related breaking changes so you can address them before the upgrade.If you're running an Elastic Cloud on Kubernetes version earlier than 3.x, consider [upgrading ECK](https://www.elastic.co/docs/deploy-manage/upgrade/orchestrator/upgrade-cloud-on-k8s) at this stage. Although this is not required for the 7.17 → 8.19 upgrade, ECK 3.x or later is needed before performing the final upgrade to 9.x.
  </applies-item>

  <applies-item title="self:" applies-to="Self-managed Elastic deployments: Generally available">
    Before starting the upgrade, follow the [Prepare to upgrade from 7.x](https://www.elastic.co/guide/en/elastic-stack/8.19/upgrading-elastic-stack.html#prepare-to-upgrade) steps.For additional details and best practices, review the [Elasticsearch upgrade setup guide](https://www.elastic.co/guide/en/elasticsearch/reference/8.19/setup-upgrade.html).As part of your preparation, make sure to complete all tasks reported by the Upgrade Assistant, review any installed plugins for compatibility, and check whether custom client applications are affected by API-related breaking changes so you can address them before the upgrade.
  </applies-item>
</applies-switch>


### 8.19 upgrade execution

Keep the following considerations in mind when upgrading your deployment or cluster:
- If you use [Stack monitoring](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring) with a dedicated monitoring cluster, upgrade your monitoring cluster first.
- If you use [remote cluster](https://www.elastic.co/docs/deploy-manage/remote-clusters) functionality, upgrade the remote clusters first.
- Before starting the upgrade, run the same checks and validations you plan to perform afterward, so you have a baseline for comparison. Refer to the [upgrade validation](#819-validation) section for example checks.

The steps below describe how to upgrade the core components of your Elastic Stack environment, Elasticsearch, Kibana, and, when applicable, Fleet Server and Elastic APM, for each deployment type.
<applies-switch>
  <applies-item title="ess:" applies-to="Elastic Cloud Hosted: Generally available">
    To upgrade your deployment to 8.19, follow the steps in [Upgrade on Elastic Cloud → Perform the upgrade](https://www.elastic.co/guide/en/elastic-stack/8.19/upgrade-elastic-stack-for-elastic-cloud.html#perform-cloud-upgrade).During the upgrade process, all components of your deployment are upgraded in the expected order:
    - Elasticsearch
    - Kibana
    - Integrations Server (Fleet Server, Elastic APM), if present
    - Enterprise Search, if present
  </applies-item>

  <applies-item title="ece:" applies-to="Elastic Cloud Enterprise: Generally available">
    To upgrade your deployment to 8.19, follow the steps in [Upgrade on Elastic Cloud → Perform the upgrade](https://www.elastic.co/guide/en/elastic-stack/8.19/upgrade-elastic-stack-for-elastic-cloud.html#perform-cloud-upgrade).
    <note>
      Although this guide refers to Elastic Cloud, the same steps apply to ECE deployments.
    </note>
    During the upgrade process, all components of your deployment are upgraded in the expected order:
    - Elasticsearch
    - Kibana
    - Integrations Server (Fleet Server, Elastic APM), if present
    - Enterprise Search, if present
  </applies-item>

  <applies-item title="eck:" applies-to="Elastic Cloud on Kubernetes: Generally available">
    In ECK, upgrades are performed declaratively by updating the `spec.version` field in your resource manifests, or by setting the equivalent version values when deploying through Helm charts. Once the new version is applied, the operator orchestrates a rolling upgrade, ensuring components are upgraded safely and in the correct order.To upgrade your cluster to 8.19, follow the steps in [Upgrade on ECK](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/upgrade-on-eck), and start by upgrading the Elasticsearch and Kibana resources that represent the cluster. Set the `version` field to the latest 8.19.x release number in each manifest or Helm chart values file.
    <note>
      For more information on how ECK manages upgrades and how to tune its behavior, refer to [Nodes orchestration](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/nodes-orchestration).
    </note>
    After upgrading Elasticsearch and Kibana, upgrade any [other Elastic applications](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/orchestrate-other-elastic-applications) connected to the cluster, such as Fleet Server or Elastic APM, using the same version value.
  </applies-item>

  <applies-item title="self:" applies-to="Self-managed Elastic deployments: Generally available">
    To upgrade your cluster to 8.19, follow the steps in [Upgrade self-managed Elastic Stack](https://www.elastic.co/guide/en/elastic-stack/8.19/upgrading-elastic-stack-on-prem.html).Make sure to upgrade all components in the specified order.
  </applies-item>
</applies-switch>


### 8.19 upgrade validation

After completing the upgrade, verify that your system is fully operational. Check that data ingestion and search are working as expected, clients and integrations can connect, and Kibana is accessible.
Confirm that the cluster is healthy and reports the expected version. You can use the following APIs to validate the cluster status after the upgrade:
- Check cluster health
  ```json
  ```
  Ensure the status is green, or yellow if that is expected for your configuration (for example, in single-node clusters).
- Check nodes and version
  ```json
  ```
  Verify that all nodes report the upgraded version in the version column.


### Upgrade ingest components and Elasticsearch client libraries to 8.19.x

Before upgrading to 9.3.0, ensure that all ingest components and Elasticsearch clients are upgraded to version 8.19.x, as 7.x versions aren’t compatible with Elastic Stack 9.x, according to the [Product compatibility support matrix](https://www.elastic.co/support/matrix#matrix_compatibility).
For more details, refer to the documentation of the following products and client libraries:
<dropdown title="8.19 Elastic Stack ingest components">
  - Beats: [Upgrade instructions](https://www.elastic.co/guide/en/beats/libbeat/8.19/upgrading.html)
  - Logstash: [Upgrade instructions](https://www.elastic.co/guide/en/logstash/8.19/upgrading-logstash.html)
  - Fleet managed Elastic Agent: [Upgrade instructions](https://www.elastic.co/guide/en/fleet/8.19/upgrade-elastic-agent.html)
  - Standalone Elastic Agent: [Upgrade instructions](https://www.elastic.co/guide/en/fleet/8.19/upgrade-standalone.html)
  - Elastic APM: [Upgrade instructions](https://www.elastic.co/guide/en/observability/8.19/apm-upgrade.html).
  - Enterprise Search: [Upgrade and migration guides](https://www.elastic.co/guide/en/enterprise-search/8.19/upgrading-and-migrating.html)

  <note>
    The Elastic APM Server and Enterprise Search components require manual upgrade only in ECK-managed or self-managed environments. In Elastic Cloud Hosted and Elastic Cloud Enterprise, these components are upgraded automatically as part of the deployment upgrade process.
  </note>
</dropdown>

<dropdown title="8.19 Elasticsearch client libraries">
  - [Go](https://www.elastic.co/guide/en/elasticsearch/client/go-api/8.19/index.html)
  - [Java](https://www.elastic.co/guide/en/elasticsearch/client/java-api-client/8.19/index.html)
  - [JavaScript (Node.js)](https://www.elastic.co/guide/en/elasticsearch/client/javascript-api/8.19/index.html)
  - [.NET](https://www.elastic.co/guide/en/elasticsearch/client/net-api/8.19/index.html)
  - [PHP](https://www.elastic.co/guide/en/elasticsearch/client/php-api/8.19/index.html)
  - [Python](https://www.elastic.co/guide/en/elasticsearch/client/python-api/8.19/index.html)
  - [Ruby](https://www.elastic.co/guide/en/elasticsearch/client/ruby-api/8.19/index.html)
  - [Rust](https://www.elastic.co/guide/en/elasticsearch/client/rust-api/8.19/overview.html)
</dropdown>

After upgrading your ingest components and client libraries, verify that they’re running correctly and sending data to the cluster before proceeding with the next major upgrade.
<note>
  At this point, you have a fully operational Elastic Stack 8.19.x environment. You can choose to remain on this version, as it’s fully maintained and supported.However, we recommend upgrading to 9.3.0 to benefit from the latest features and performance improvements.
</note>


## Upgrade step 2: 8.19.x → 9.3.0

This step covers upgrading your deployment from 8.19.x to 9.3.0, assuming that all ingest components have been upgraded to 8.19.x, and client libraries are compatible with 9.x.
It's highly recommended to start this upgrade from the latest 8.19.x patch release to ensure that you’re using the most recent version of the Upgrade Assistant.
<admonition title="Important note for Enterprise Search users">
  In Elastic Stack 9.0.0 and later, Enterprise Search is no longer available.
  - You must remove any Enterprise Search nodes from your deployment before proceeding with the upgrade.
  - If you are currently using App Search, Workplace Search, or the Elastic Web Crawler, these features will cease to function if you remove Enterprise Search from your deployment. Therefore, it is critical to first  [migrate your Enterprise Search use cases](https://www.elastic.co/guide/en/enterprise-search/8.19/upgrading-to-9-x.html) before decommissioning your Enterprise Search instances.
</admonition>


### 9.3.0 upgrade preparations

The [upgrade preparation steps](https://www.elastic.co/docs/deploy-manage/upgrade/prepare-to-upgrade) are designed to prevent upgrade failures by detecting and addressing internal incompatibilities, including deprecated settings that are no longer supported in the next release.
During a major upgrade, the [Upgrade Assistant](https://www.elastic.co/docs/deploy-manage/upgrade/prepare-to-upgrade/upgrade-assistant) in Kibana 8.19 plays a critical role. It scans your cluster for deprecated settings, incompatible indices, and other issues that could prevent nodes from starting after the upgrade. The tool guides you through reindexing old 7.x indices or marking them as read-only, fixing configuration problems, and reviewing deprecation logs to ensure your deployment is fully compatible with the next major version. Ignoring its recommendations can lead to upgrade failures or cluster downtime.
While the Upgrade Assistant helps you identify breaking changes that affect your deployment or cluster, it's still recommended to review the complete list of breaking changes and known issues in every release from your current version through your target version as part of the preparation phase. These are available in the following documents:
- [Elasticsearch 9.x breaking changes](https://www.elastic.co/docs/release-notes/elasticsearch/breaking-changes)
- [Kibana breaking changes summary](https://www.elastic.co/docs/release-notes/kibana/breaking-changes)

Follow the guidelines below for your specific deployment type:
<applies-switch>
  <applies-item title="ess:" applies-to="Elastic Cloud Hosted: Generally available">
    The Elastic Cloud platform facilitates major upgrades by doing the following:
    - Automatically creating a snapshot before the upgrade.
    - Detecting deprecated settings and index compatibility issues.
    - Blocking the upgrade until all issues are resolved through the Upgrade Assistant, ensuring a reliable outcome.
    To prepare your deployment for the upgrade, review the [Prepare to upgrade](https://www.elastic.co/docs/deploy-manage/upgrade/prepare-to-upgrade) guide. You should make sure to:
    1. [Run the Upgrade Assistant](/docs/deploy-manage/upgrade/prepare-to-upgrade#run-the-upgrade-assistant) in Kibana and resolve all critical issues before continuing.
       As described in the linked guide, the assistant helps you:
       - Reindex or mark as read-only legacy indices and data streams (created before 8.0).
    - Remove or update deprecated settings and mappings.
    - Review deprecation logs for both Elasticsearch and Kibana.
    - Remove Enterprise Search if it's part of the deployment.
       <note>
       If the Upgrade Assistant reports old machine learning, cross-cluster replication, or transform indices that require action or reindexing, make sure to review the relevant sections in the preparations guide:
       - [Manage CCR follower data streams](/docs/deploy-manage/upgrade/prepare-to-upgrade#manage-ccr-follower-data-streams)
       - [Manage old Machine Learning indices](/docs/deploy-manage/upgrade/prepare-to-upgrade#manage-old-machine-learning-indices)
       - [Manage old Transform indices](/docs/deploy-manage/upgrade/prepare-to-upgrade#manage-old-transform-indices)
       </note>
    2. If you use [custom plugins or bundles](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/upload-custom-plugins-bundles), make sure they’re compatible with the next major release.
    3. If you use custom-developed applications that are impacted by API-related breaking changes, make the recommended changes to ensure that your applications continue to operate as expected after the upgrade, or, as a temporary solution, you can use [REST API compatibility mode](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/compatibility) to submit requests to 9.x using the 8.x syntax.
       <note>
       The REST API compatibility mode should only serve as a bridge to ease the upgrade process, not as a long-term strategy. For a high-level description of the steps to ensure a smooth upgrade involving client applications that use this mode, refer to the [REST API compatibility workflow example](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/compatibility#_rest_api_compatibility_workflow).
       </note>
  </applies-item>

  <applies-item title="ece:" applies-to="Elastic Cloud Enterprise: Generally available">
    <important>
      If you're running an Elastic Cloud Enterprise version earlier than 4.x, ensure that you [upgrade ECE first](https://www.elastic.co/docs/deploy-manage/upgrade/orchestrator/upgrade-cloud-enterprise). ECE 3.x is not compatible with Elastic Stack version 9.
    </important>
    Elastic Cloud Enterprise platform facilitates major upgrades by:
    - When [snapshots are configured](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/cloud-enterprise), automatically creating a snapshot before the upgrade.
    - Detecting deprecated settings and index compatibility issues.
    - Blocking the upgrade until all issues are resolved through the Upgrade Assistant, ensuring a reliable outcome.
    To prepare your deployment for the upgrade, review the [Prepare to upgrade](https://www.elastic.co/docs/deploy-manage/upgrade/prepare-to-upgrade) guide. You should make sure to:
    1. [Run the Upgrade Assistant](/docs/deploy-manage/upgrade/prepare-to-upgrade#run-the-upgrade-assistant) in Kibana and resolve all critical issues before continuing.
       As described in the linked guide, the assistant helps you:
       - Reindex or mark as read-only legacy indices and data streams (created before 8.0).
    - Remove or update deprecated settings and mappings.
    - Review deprecation logs for both Elasticsearch and Kibana.
    - Remove Enterprise Search if it's part of the deployment.
       <note>
       If the Upgrade Assistant reports old machine learning, cross-cluster replication, or transform indices that require action or reindexing, make sure to review the relevant sections in the preparations guide:
       - [Manage CCR follower data streams](/docs/deploy-manage/upgrade/prepare-to-upgrade#manage-ccr-follower-data-streams)
       - [Manage old Machine Learning indices](/docs/deploy-manage/upgrade/prepare-to-upgrade#manage-old-machine-learning-indices)
       - [Manage old Transform indices](/docs/deploy-manage/upgrade/prepare-to-upgrade#manage-old-transform-indices)
       </note>
    2. If you use [custom plugins or bundles](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/upload-custom-plugins-bundles), make sure they're compatible with the next major release.
    3. If you use custom-developed applications that are impacted by API-related breaking changes, make the recommended changes to ensure that your applications continue to operate as expected after the upgrade, or, as a temporary solution, you can use [REST API compatibility mode](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/compatibility) to submit requests to 9.x using the 8.x syntax.
       <note>
       The REST API compatibility mode should only serve as a bridge to ease the upgrade process, not as a long-term strategy. For a high-level description of the steps to ensure a smooth upgrade involving client applications that use this mode, refer to the [REST API compatibility workflow example](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/compatibility#_rest_api_compatibility_workflow).
       </note>
  </applies-item>

  <applies-item title="eck:" applies-to="Elastic Cloud on Kubernetes: Generally available">
    <important>
      If you're running an Elastic Cloud on Kubernetes version earlier than 3.x, ensure that you [upgrade ECK first](https://www.elastic.co/docs/deploy-manage/upgrade/orchestrator/upgrade-cloud-on-k8s). ECK 2.x is not compatible with Elastic Stack version 9.
    </important>
    Upgrade preparations for an ECK-managed cluster are similar to a self-managed deployment.Before starting the upgrade, follow the steps in [Prepare to upgrade](https://www.elastic.co/docs/deploy-manage/upgrade/prepare-to-upgrade).As part of your preparation, make sure to complete all tasks reported by the Upgrade Assistant, review any installed plugins for compatibility, and check whether custom client applications are affected by API-related breaking changes so you can address them before the upgrade.
  </applies-item>

  <applies-item title="self:" applies-to="Self-managed Elastic deployments: Generally available">
    Before starting the upgrade, follow the steps in [Prepare to upgrade](https://www.elastic.co/docs/deploy-manage/upgrade/prepare-to-upgrade).As part of your preparation, make sure to complete all tasks reported by the Upgrade Assistant, review any installed plugins for compatibility, and check whether custom client applications are affected by API-related breaking changes so you can address them before the upgrade.
  </applies-item>
</applies-switch>


### 9.3.0 upgrade execution

As with the previous major upgrade, keep the following considerations in mind when upgrading your deployment or cluster:
- If you use [Stack monitoring](https://www.elastic.co/docs/deploy-manage/monitor/stack-monitoring) with a dedicated monitoring cluster, upgrade your monitoring cluster first.
- If you use [remote cluster](https://www.elastic.co/docs/deploy-manage/remote-clusters) functionality, upgrade the remote clusters first.
- Before starting the upgrade, run the same checks and validations you plan to perform afterward, so you have a baseline for comparison. Refer to the [upgrade validation](#819-validation) section for example checks.

The steps below describe how to upgrade the core components of your Elastic Stack environment, Elasticsearch, Kibana, and, when applicable, Fleet Server and Elastic APM, for each deployment type.
<applies-switch>
  <applies-item title="ess:" applies-to="Elastic Cloud Hosted: Generally available">
    To upgrade your deployment to 9.3.0, follow the steps in [Upgrade your deployment on ECH](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/upgrade-on-ech).During the upgrade process all of your deployment components will be upgraded in the expected order:
    - Elasticsearch
    - Kibana
    - Integrations Server (Fleet Server, Elastic APM), if present
  </applies-item>

  <applies-item title="ece:" applies-to="Elastic Cloud Enterprise: Generally available">
    To upgrade your deployment to 9.3.0, follow the steps in [Upgrade your deployment on ECE](/docs/deploy-manage/upgrade/deployment-or-cluster/upgrade-on-ece#perform-the-upgrade).If the [Elastic Stack pack](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/manage-elastic-stack-versions) for this version isn’t already added to the platform, make sure to add it before starting the upgrade.During the upgrade process all of your deployment components will be upgraded in the expected order:
    - Elasticsearch
    - Kibana
    - Integrations Server (Fleet Server, Elastic APM), if present
  </applies-item>

  <applies-item title="eck:" applies-to="Elastic Cloud on Kubernetes: Generally available">
    In ECK, upgrades are performed declaratively by updating the `spec.version` field in your resource manifests, or by setting the equivalent version values when deploying through Helm charts. Once the new version is applied, the operator orchestrates a rolling upgrade, ensuring components are upgraded safely and in the correct order.To upgrade your cluster to 9.3.0, follow the steps in [Upgrade on ECK](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/upgrade-on-eck), and start by upgrading the Elasticsearch and Kibana resources that represent the cluster. Set the version field to 9.3.0 in each manifest or Helm chart values file.
    <note>
      For more information on how ECK manages upgrades and how to tune its behavior, refer to [Nodes orchestration](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/nodes-orchestration).
    </note>
    After upgrading Elasticsearch and Kibana, upgrade any [other Elastic applications](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/orchestrate-other-elastic-applications) connected to the cluster, such as Fleet Server or Elastic APM, using the same version value.
  </applies-item>

  <applies-item title="self:" applies-to="Self-managed Elastic deployments: Generally available">
    To upgrade your cluster to 9.3.0, follow the steps in [Upgrade a self-managed cluster](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/self-managed).Make sure to upgrade all components in the specified order:
    1. [Upgrade Elasticsearch](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/elasticsearch) following the rolling upgrade method.
    2. [Upgrade Kibana](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/kibana)
  </applies-item>
</applies-switch>


### 9.3.0 upgrade validation

After completing the upgrade, verify that your system is fully operational. Check that data ingestion and search are working as expected, clients and integrations can connect, and Kibana is accessible.
Confirm that the cluster is healthy and reports the expected version. You can use the following APIs to validate the cluster status after the upgrade:
- Check cluster health
  ```json
  ```
  Ensure the status is green, or yellow if that is expected for your configuration (for example, in single-node clusters).
- Check nodes and version
  ```json
  ```
  Verify that all nodes report the upgraded version in the version column.


### Upgrade ingest components and Elasticsearch client libraries to 9.3.0

After upgrading your deployment or cluster to 9.3.0, review your ingest components and client libraries to ensure full compatibility across the environment.
All custom-developed applications that rely on [Elasticsearch client libraries](https://www.elastic.co/docs/reference/elasticsearch-clients) must be upgraded to the latest 9.3.0 client version to guarantee full API compatibility and support for new features.
For ingest components, version 8.19.x remains fully compatible with the entire 9.x series. You can keep running them on 8.19.x if you prefer a gradual rollout. However, we recommend upgrading to 9.3.0 to take advantage of ongoing improvements and new features.
For more details, refer to the documentation of the following products and client libraries:
<dropdown title="9.3.0 Elastic Stack ingest components">
  - Beats: [Upgrade instructions](https://www.elastic.co/docs/reference/beats/libbeat/upgrading)
  - Logstash: [Upgrade instructions](https://www.elastic.co/docs/reference/logstash/upgrading-logstash)
  - Fleet managed Elastic Agent: [Upgrade instructions](https://www.elastic.co/docs/reference/fleet/upgrade-elastic-agent)
  - Standalone Elastic Agent: [Upgrade instructions](https://www.elastic.co/docs/reference/fleet/upgrade-standalone)
  - Elastic APM: [Upgrade instructions](https://www.elastic.co/docs/solutions/observability/apm/upgrade)
</dropdown>

<dropdown title="9.3.0 Elasticsearch client libraries">
  - [Go](https://www.elastic.co/docs/reference/elasticsearch/clients/go)
  - [Java](https://www.elastic.co/docs/reference/elasticsearch/clients/java)
  - [JavaScript (Node.js)](https://www.elastic.co/docs/reference/elasticsearch/clients/javascript)
  - [.NET](https://www.elastic.co/docs/reference/elasticsearch/clients/dotnet)
  - [PHP](https://www.elastic.co/docs/reference/elasticsearch/clients/php)
  - [Python](https://www.elastic.co/docs/reference/elasticsearch/clients/python)
  - [Eland](https://www.elastic.co/docs/reference/elasticsearch/clients/eland)
  - [Ruby](https://www.elastic.co/docs/reference/elasticsearch/clients/ruby)
  - [Rust](https://www.elastic.co/docs/reference/elasticsearch/clients/rust)
</dropdown>

After completing the upgrades, verify that all ingest components and client applications can connect and send data to the deployment without issues.

## Next steps

You now have a fully upgraded Elastic Stack 9.3.0 environment. To explore new capabilities, see [What’s new in 9.3.0](/docs/release-notes#whats-new-in-the-latest-elastic-release).