﻿---
title: Upgrade the Elastic Stack on a self-managed cluster
description: If you've installed the Elastic Stack on your own self-managed infrastructure, once you're prepared to upgrade, you'll need to upgrade each of your Elastic...
url: https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/self-managed
products:
  - Elasticsearch
  - Kibana
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Upgrade the Elastic Stack on a self-managed cluster
If you've installed the Elastic Stack on your own self-managed infrastructure, once you're [prepared to upgrade](https://www.elastic.co/docs/deploy-manage/upgrade/prepare-to-upgrade), you'll need to upgrade each of your Elastic components individually.
It's important that you upgrade your components in this order:
- [Elasticsearch](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/elasticsearch)
- [Kibana](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/kibana)
- [Elastic APM](https://www.elastic.co/docs/solutions/observability/apm/upgrade)
- [Ingest components](https://www.elastic.co/docs/deploy-manage/upgrade/ingest-components)

<important>
  If you're using Logstash and the `logstash-filter-elastic_integration` [plugin](https://www.elastic.co/docs/reference/logstash/plugins/plugins-filters-elastic_integration) to extend Elastic integrations, upgrade Logstash (or the `logstash-filter-elastic_integration` plugin specifically) *before* you upgrade Kibana.The Elasticsearch → Logstash → Kibana installation order for this specific plugin ensures the best experience with Elastic Agent-managed pipelines, and embeds functionality from a version of Elasticsearch Ingest Node that is compatible with the plugin version (`major.minor`).
</important>