﻿---
title: Upgrade Kibana
description: When you upgrade Kibana, you also upgrade the Observability and Elastic Security solutions, which use Kibana as their main interface. Kibana must always...
url: https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/kibana
products:
  - Kibana
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Upgrade Kibana
When you upgrade Kibana, you also upgrade the Observability and Elastic Security solutions, which use Kibana as their main interface.
Kibana must always be upgraded after Elasticsearch, and to the same version. Version mismatches or upgrading in the wrong order can result in failures or unexpected behavior.
<warning>
  Kibana automatically runs saved object migrations when required. To roll back to an earlier version in case of an upgrade failure, you **must** have a [backup snapshot](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore) that includes the `kibana` feature state. Snapshots include this feature state by default.For more information, refer to [Migrate saved objects](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/saved-object-migrations).
</warning>


## Upgrading multiple Kibana instances

When upgrading several Kibana instances connected to the same Elasticsearch cluster, ensure that all outdated instances are shut down before starting the upgrade.
Rolling upgrades are unsupported in Kibana. However, when outdated instances are shut down, you can start all upgraded instances in parallel, which allows all instances to participate in the upgrade in parallel.
For large deployments with more than 10 Kibana instances, and more than 10,000 saved objects, you can reduce the upgrade downtime by bringing up a single Kibana instance and waiting for it to complete the upgrade before bringing up the remaining instances.

## Preparing for upgrading

Before you start, ensure that you’ve followed the [Plan your upgrade](https://www.elastic.co/docs/deploy-manage/upgrade/plan-upgrade) guidelines, completed the [upgrade preparation steps](https://www.elastic.co/docs/deploy-manage/upgrade/prepare-to-upgrade), and [upgraded the Elasticsearch cluster](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/elasticsearch).

### Ensure your Elasticsearch cluster is healthy

Problems with your Elasticsearch cluster can prevent Kibana upgrades from succeeding.
During the upgrade process, Kibana creates new indices into which updated documents are written. If a cluster is approaching the low watermark, there’s a high risk of Kibana not being able to create these. Reading, transforming and writing updated documents can be memory intensive, using more available heap than during routine operation. You must make sure that enough heap is available to prevent requests from timing out or throwing errors from circuit breaker exceptions. You should also ensure that all shards are replicated and assigned.
A healthy cluster has:
- Enough free disk space, at least twice the amount of storage taken up by the `.kibana` and `.kibana_task_manager` indices
- Sufficient heap size
- A "green" cluster status


### Ensure that all Kibana instances are the same

When you perform an upgrade of different Kibana versions, the upgrade can fail. Ensure that all Kibana instances are running the same version, configuration, and plugins.

## Perform the upgrade

To upgrade Kibana:
1. Shut down all Kibana instances. Kibana does not support rolling upgrades. **Upgrading while older Kibana instances are running can cause data loss or upgrade failures.**
2. To install the `deb` or `rpm` package:
   1. Use `rpm` or `dpkg`. This installs all files in their proper locations and will not overwrite the config files.
2. Upgrade any plugins by removing the existing plugin and reinstalling the appropriate version using the `kibana-plugin` script. For more information, refer to [Kibana plugins](https://www.elastic.co/docs/reference/kibana/kibana-plugins).
3. To install from a `zip` or `tar.gz` archive:
   1. **Extract the archive to a new directory** to be sure that you don’t overwrite the `config` or `data` directories.
2. Copy the files from the `config` directory from your old installation to your new installation.
3. Copy the files from the `data` directory from your old installation to your new installation.
   <important>
   If you use monitoring features, you must re-use the data directory when you upgrade Kibana. Otherwise, the Kibana instance is assigned a new persistent UUID and becomes a new instance in the monitoring data.
   </important>
   1. Install the appropriate versions of all your plugins for your new installation using the `kibana-plugin` script. For more information, refer to [Kibana plugins](https://www.elastic.co/docs/reference/kibana/kibana-plugins).
4. Start Kibana.

<note>
  Kibana 8.0.0 and later uses a new logging system, so the log formats have changed. For additional information, refer to [Logging configuration changes](https://www.elastic.co/docs/extend/kibana/logging-config-changes).
</note>


## Next steps

Once you've successfully upgraded Kibana, [upgrade Elastic APM](https://www.elastic.co/docs/solutions/observability/apm/upgrade), then [upgrade your ingest components](https://www.elastic.co/docs/deploy-manage/upgrade/ingest-components).