﻿---
title: Roll back to a previous version of Kibana
description: If you’ve followed preparing for migration and resolving migration failures, and Kibana is still unable to successfully upgrade, roll back Kibana until...
url: https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/kibana-roll-back
products:
  - Kibana
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Roll back to a previous version of Kibana
If you’ve followed [preparing for migration](/docs/deploy-manage/upgrade/deployment-or-cluster/kibana#preventing-migration-failures) and [resolving migration failures](https://www.elastic.co/docs/troubleshoot/kibana/migration-failures), and Kibana is still unable to successfully upgrade, roll back Kibana until you identify and fix the root cause.
<warning>
  Before you roll back Kibana, ensure that the version you want to roll back to is compatible with your Elasticsearch cluster. If the version you want to roll back to is not compatible, you must also roll back Elasticsearch. Any changes made after an upgrade are lost when you roll back to a previous version.
</warning>

To roll back after a failed upgrade migration, you must also roll back the Kibana feature state to be compatible with the previous Kibana version.

## Roll back by restoring the Kibana feature state from a snapshot

1. Before proceeding, [take a snapshot](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/create-snapshots) that contains the `kibana` feature state. By default, snapshots include the `kibana` feature state.
2. To make sure no Kibana instances are performing an upgrade migration, shut down all Kibana instances.
3. [Restore](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/restore-snapshot) the `kibana` feature state from a snapshot taken before the failed Kibana upgrade. The following Elasticsearch request will only restore the Kibana feature state:
   ```json

   {
     "indices": "-*", <1>
     "feature_states": ["kibana"]
   }
   ```
4. Start all Kibana instances on the older version you want to roll back to.