﻿---
title: Elasticsearch archived settings
description: If you upgrade a cluster with a deprecated persistent cluster setting to a version that no longer supports the setting, Elasticsearch automatically archives...
url: https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/archived-settings
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Elasticsearch archived settings
If you upgrade a cluster with a deprecated persistent cluster setting to a version that no longer supports the setting, Elasticsearch automatically archives that setting. Similarly, if you upgrade a cluster that contains an index with an unsupported index setting, Elasticsearch archives the index setting.
You should remove any archived settings after upgrading. Archived settings are considered invalid and can interfere with your ability to configure other settings.
Archived settings start with the `archived.` prefix.

## Archived cluster settings

Use the following [cluster update settings](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-put-settings) request to check for archived cluster settings. If the request returns an empty object (`{ }`), there are no archived cluster settings.
```json
```

To remove any archived cluster settings, use the following [cluster update settings](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-put-settings) request.
```json

{
  "persistent": {
    "archived.*": null
  }
}
```

Elasticsearch doesn’t archive transient cluster settings or settings in [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings). If a node includes an unsupported setting in `elasticsearch.yml`, it will return an error at startup.

## Archived index settings

<important>
  Before upgrading, remove any unsupported index settings from index and component templates. Elasticsearch doesn't archive unsupported index settings in templates during an upgrade. Attempts to use a template that contains an unsupported index setting will fail and return an error. This includes automated operations, such the ILM rollover action.
</important>

Archived index settings don’t affect an index’s configuration or most index operations, such as indexing or search. However, you’ll need to remove them before you can configure other settings for the index, such as `index.hidden`.
Use the following [get index settings](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-get-settings) request to get a list indices with archived settings. If the request returns an empty object (`{ }`), there are no archived index settings.
```json
```

To remove any archived index settings, use the following [indices update settings](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-settings) request.
```json

{
  "archived.*": null
}
```