﻿---
title: Upgrade your deployment or cluster
description: This section contains the upgrade instructions for Elasticsearch clusters and Kibana instances. Upgrade procedures depend on whether you installed Elastic...
url: https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster
products:
  - Elastic Cloud Enterprise
  - Elastic Cloud Hosted
  - Elastic Cloud on Kubernetes
  - Elasticsearch
  - Kibana
applies_to:
  - Elastic Stack: Generally available
---

# Upgrade your deployment or cluster
This section contains the upgrade instructions for Elasticsearch clusters and Kibana instances. Upgrade procedures depend on whether you installed Elastic components using Elastic-managed or self-managed infrastructure.

## Prerequisites

Before proceeding with the upgrade, review the [Plan your upgrade](https://www.elastic.co/docs/deploy-manage/upgrade/plan-upgrade) guidance to understand compatibility and timing considerations, and follow the steps in [Prepare to upgrade](https://www.elastic.co/docs/deploy-manage/upgrade/prepare-to-upgrade) to get your environment ready for the upgrade.
Additionally, review the [Restrictions and known problems](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/restrictions-known-problems) section to gain a comprehensive understanding of the known issues in Elastic Cloud Hosted.
If you’re still running Elastic Stack version 7.17 or earlier, refer to the [Upgrade from 7.17 guide](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/upgrade-717) for detailed guidance on planning and executing the upgrade to the latest 9.3.0 release.

## Out-of-order releases

Elastic maintains several minor versions of Elasticsearch at the same time. This means releases do not always happen in order of their version numbers. You can only upgrade to 9.3.0 if the version you are currently running meets both of these conditions:
- Has a lower version number than 9.3.0
- Has an earlier release date than 9.3.0

If you are currently running a version with a lower version number but a later release date than 9.3.0, wait for a newer release before upgrading.
Additionally, upgrading from a release candidate build, such as 9.0.0-rc1, is unsupported. Use pre-releases only for testing in a temporary environment.

## Upgrade methods

If you’re using Elastic-managed infrastructure, use the following options:
- [Upgrade on Elastic Cloud Hosted](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/upgrade-on-ech)

If you’re using self-managed infrastructure - either on-prem or public cloud - use the following options:
- [Upgrade the Elastic Stack on a self-managed cluster](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/self-managed)
- [Upgrade your deployment on Elastic Cloud Enterprise (ECE)](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/upgrade-on-ece)
- [Upgrade your deployment on Elastic Cloud on Kubernetes (ECK)](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/upgrade-on-eck)

<note>
  With [Elastic Cloud Serverless](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/serverless), upgrades of the Elastic-managed infrastructure and project components are fully handled by Elastic. Users automatically receive the latest features and improvements, with no need to plan or perform project-level upgrades.Keep in mind that the [ingest components](https://www.elastic.co/docs/deploy-manage/upgrade/ingest-components) or clients you manage externally, such as Elastic Agent, Beats, Logstash, or custom applications, still need to be updated manually.
</note>


## Next steps

Once you've successfully upgraded your deployment, you can [upgrade your ingest components](https://www.elastic.co/docs/deploy-manage/upgrade/ingest-components), such as Logstash, Elastic Agent, or Beats.