﻿---
title: Uninstall Elastic Cloud on Kubernetes
description: This page provides instructions for uninstalling Elastic Cloud on Kubernetes, including removing all Elastic resources and the Elastic Cloud on Kubernetes...
url: https://www.elastic.co/docs/deploy-manage/uninstall/uninstall-elastic-cloud-on-kubernetes
products:
  - Elastic Cloud on Kubernetes
applies_to:
  - Elastic Cloud on Kubernetes: Generally available
---

# Uninstall Elastic Cloud on Kubernetes
This page provides instructions for uninstalling Elastic Cloud on Kubernetes, including removing all Elastic resources and the Elastic Cloud on Kubernetes operator from your cluster.
To uninstall the operator:
1. Remove all Elastic resources in all namespaces:
   ```shell
   kubectl get namespaces --no-headers -o custom-columns=:metadata.name \
     | xargs -n1 kubectl delete elastic --all -n
   ```
   This deletes all underlying Elastic Stack resources, including their Pods, Secrets, Services, and so on.
2. Uninstall the operator:
   ```shell
   kubectl delete -f https://download.elastic.co/downloads/eck/3.3.0/operator.yaml
   kubectl delete -f https://download.elastic.co/downloads/eck/3.3.0/crds.yaml
   ```

<warning>
  Deleting CRDs will trigger deletion of all custom resources (Elasticsearch, Kibana, APM Server, Beats, Elastic Agent, Elastic Maps Server, and Logstash) in all namespaces of the cluster, regardless of whether they are managed by a single operator or multiple operators.
</warning>