﻿---
title: Uninstall Elastic Cloud Enterprise
description: This guide provides instructions for uninstalling Elastic Cloud Enterprise from a specific host within an Elastic Cloud Enterprise platform. This process...
url: https://www.elastic.co/docs/deploy-manage/uninstall/uninstall-elastic-cloud-enterprise
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Uninstall Elastic Cloud Enterprise
This guide provides instructions for uninstalling Elastic Cloud Enterprise from a specific host within an Elastic Cloud Enterprise platform. This process removes the Elastic Cloud Enterprise software from the host but does not uninstall the entire Elastic Cloud Enterprise platform.
You might need to remove Elastic Cloud Enterprise for one of the following reasons:
- The installation process does not complete successfully and you can't troubleshoot the issue.
- You are de-provisioning a host and want to remove the installed Elastic Cloud Enterprise software.

<important>
  If the Elastic Cloud Enterprise host you are uninstalling has the allocator role and is running instances from orchestrated deployments, all containers will be deleted, causing the instances to appear unhealthy on the Deployments page. To avoid disruptions, it is recommended to [vacate the host](https://www.elastic.co/docs/deploy-manage/maintenance/ece/move-nodes-instances-from-allocators) before uninstalling Elastic Cloud Enterprise.
</important>

You can remove Elastic Cloud Enterprise by removing all containers on the host:
- If using Docker:
  ```sh
  docker rm -f frc-runners-runner frc-allocators-allocator $(docker ps -a -q); sudo rm -rf /mnt/data/elastic/ && docker ps -a
  ```
- If using Podman:
  ```sh
  sudo podman rm -f frc-runners-runner frc-allocators-allocator $(sudo podman ps -a -q); sudo rm -rf /mnt/data/elastic && sudo podman ps -a
  ```

If you plan to reinstall Elastic Cloud Enterprise on the host, make sure you [delete the host](https://www.elastic.co/docs/deploy-manage/maintenance/ece/delete-ece-hosts) from the Cloud UI first. Reinstallation can fail if the host is still associated with your old Elastic Cloud Enterprise installation.
<warning>
  During installation, the system generates secrets that are placed into the `/mnt/data/elastic/bootstrap-state/bootstrap-secrets.json` secrets file, unless you passed in a different path with the `--host-storage-path` parameter. Keep the information in the `bootstrap-secrets.json` file secure by removing it from its default location and placing it into a secure storage location.
</warning>