﻿---
title: Delete an orchestrated deployment
description: This page provides instructions for deleting several types of cloud deployments, and outlines key considerations before proceeding. To delete an Elastic...
url: https://www.elastic.co/docs/deploy-manage/uninstall/delete-a-cloud-deployment
products:
  - Elastic Cloud Enterprise
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
---

# Delete an orchestrated deployment
This page provides instructions for deleting several types of cloud deployments, and outlines key considerations before proceeding.

## Elastic Cloud Hosted

To delete an Elastic Cloud Hosted deployment:
1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
2. On the deployment overview page, select **Actions**, then select **Delete deployment** and confirm the deletion.

When you delete your deployment, billing stops immediately, rounding up to the nearest hour.
<warning>
  When deployments are deleted, we erase all data on disk, including snapshots. Snapshots are retained for very a limited amount of time post deletion and we cannot guarantee that deleted deployments can be restored from snapshots for this reason. If you accidentally delete a deployment, contact support as soon as possible to increase the likelihood of restoring your deployment.
</warning>

<tip>
  If you want to keep the snapshot for future purposes even after the deployment deletion, you should [use a custom snapshot repository](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/elastic-cloud-hosted).
</tip>


## Serverless

To delete a Elastic Cloud Serverless project:
1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
2. Find your project on the home page in the **Serverless Projects** card and select **Manage** to access it directly. Or, select **Serverless Projects** to go to the projects page to view all of your projects.
3. Select **Actions**, then select **Delete project** and confirm the deletion.

<warning>
  All data is lost. Billing for usage is by the hour and any outstanding charges for usage before you deleted the project will still appear on your next bill.
</warning>


## Elastic Cloud Enterprise


### Delete a deployment

To delete an Elastic Cloud Enterprise deployment:
1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
2. On the **Deployments** page, select your deployment.
   Narrow the list by name, ID, or choose from several other filters. To further define the list, use a combination of filters.
3. From the **Actions** menu, [terminate the deployment](#terminate-a-deployment).
4. From the **Actions** menu, select **Delete deployment** and follow the steps to delete the deployment permanently.

<warning>
  Deleting a deployment cannot be undone.
</warning>


### Terminate a deployment

Terminating a deployment stops all running instances and **deletes all data**. Only configuration information is saved so that you can restore the deployment in the future. If there is [a snapshot repository associated](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/cloud-enterprise) with the Elasticsearch cluster and at least one snapshot has been taken, you can restore the cluster with the same indices later.
To terminate an Elastic Cloud Enterprise deployment,
1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
2. On the **Deployments** page, select your deployment.
   Narrow the list by name, ID, or choose from several other filters. To further define the list, use a combination of filters.
3. From the **Actions** menu, select **Terminate deployment**.


### Restore a deployment

You can restore a deployment that was previously terminated to its original configuration. Note that the data that was in the deployment is not restored, since it is deleted as part of the termination process. If you have a snapshot, you can [restore it](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/restore-snapshot) to recover the Elasticsearch indices.
To restore a terminated deployment,
1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
2. On the **Deployments** page, select your deployment.
   Narrow the list by name, ID, or choose from several other filters. To further define the list, use a combination of filters.
3. From the **Actions** menu, select **Restore deployment** and then acknowledge the confirmation message.


## Elastic Cloud on Kubernetes

To delete a deployment managed by Elastic Cloud on Kubernetes, remove the corresponding Elasticsearch, Kibana, and any other related custom resources from your Kubernetes cluster. This action deletes all associated pods and their persistent data.
To delete an Elasticsearch cluster created with Elastic Cloud on Kubernetes:
1. Run the following command to delete the Elasticsearch custom resource:
   ```shell
   kubectl delete elasticsearch <elasticsearch-resource-name>
   ```
   For example:
   ```shell
   kubectl delete elasticsearch test-deployment
   ```
   <warning>
   This deletes the custom resource and all associated resources, such as Elasticsearch nodes, services, and persistent data volumes. By default, this also deletes the data stored in those volumes, but you can [configure](/docs/deploy-manage/deploy/cloud-on-k8s/volume-claim-templates#k8s_controlling_volume_claim_deletion) the `volumeClaimDeletePolicy` field in the Elasticsearch resource manifest to retain the volumes if you plan to recreate the cluster later.
   </warning>
2. If you also deployed Kibana or other stack components, delete those resources as well:
   ```shell
   kubectl delete kibana <kibana-resource-name>
   ```

<tip>
  To fully uninstall Elastic Cloud on Kubernetes from your cluster including all managed resources and the ECK operator, refer to the [Uninstall Elastic Cloud on Kubernetes](https://www.elastic.co/docs/deploy-manage/uninstall/uninstall-elastic-cloud-on-kubernetes) guide.
</tip>