﻿---
title: Restore a snapshot
description: This guide shows you how to restore a snapshot. Snapshots are a convenient way to store a copy of your data outside of a cluster. You can restore a snapshot...
url: https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/restore-snapshot
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Restore a snapshot
This guide shows you how to restore a snapshot. Snapshots are a convenient way to store a copy of your data outside of a cluster. You can restore a snapshot to recover indices and data streams after deletion or a hardware failure. You can also use snapshots to transfer data between clusters.
In this guide, you’ll learn how to:
- [Get a list of available snapshots](#get-a-list-of-available-snapshots)
- [Restore an index or data stream from a snapshot](#restore-index-data-stream)
- [Restore a feature state](#restore-feature-state)
- [Restore an entire cluster](#restore-entire-cluster)
- [Monitor the restore operation](#monitor-restore)
- [Cancel an ongoing restore](#cancel-restore)

This guide also provides tips for [restoring to another cluster](#restore-different-cluster) and [troubleshooting common restore errors](#troubleshoot-restore).

## Prerequisites

- To use Kibana's **Snapshot and Restore** feature, you must have the following permissions:
  - [Cluster privileges](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-cluster): `monitor`, `manage_slm`, `cluster:admin/snapshot`, and `cluster:admin/repository`
- [Index privilege](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-indices): `monitor` privilege on all the indices
- To register a snapshot repository or restore a snapshot, the cluster’s global metadata must be writeable. Ensure there aren’t any [cluster blocks](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/miscellaneous-cluster-settings#cluster-read-only) that prevent write access. The restore operation ignores index blocks.

- You can only restore a snapshot to a running cluster with an elected [master node](/docs/deploy-manage/distributed-architecture/clusters-nodes-shards/node-roles#master-node-role). The snapshot’s repository must be registered and available to the cluster.
- The snapshot and cluster versions must be compatible. See [Snapshot compatibility](/docs/deploy-manage/tools/snapshot-and-restore#snapshot-compatibility).
- Before you restore a data stream, ensure the cluster contains a [matching index template](/docs/manage-data/use-case-use-elasticsearch-to-manage-time-series-data#create-ts-index-template) with data stream enabled. To check, use [Kibana’s Index Management](/docs/manage-data/data-store/index-basics#index-management-manage-index-templates) feature or the get index template API:
  ```json
  ```
- If no such template exists, you can [matching index template](/docs/manage-data/use-case-use-elasticsearch-to-manage-time-series-data#create-ts-index-template) or restore a cluster state that contains one. Without a matching index template, a data stream can’t roll over or create backing indices.
- If your snapshot contains data from App Search or Workplace Search, ensure you’ve restored the Enterprise Search encryption key before restoring the snapshot.


## Considerations

When restoring data from a snapshot, keep the following in mind:
- If you restore a data stream, you also restore its backing indices.
- You can only restore an existing index if it’s closed and the index in the snapshot has the same number of primary shards.
- You can’t restore an existing open index. This includes backing indices for a data stream.
- The restore operation automatically opens restored indices, including backing indices.
- You can restore only a specific backing index from a data stream. However, the restore operation doesn’t add the restored backing index to any existing data stream.


## Get a list of available snapshots

To view a list of available snapshots in Kibana:
1. Go to the **Snapshot and Restore** management page in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Select the **Snapshots** tab.

You can also use the get repository API and the get snapshot API to find snapshots that are available to restore. First, use the get repository API to fetch a list of registered snapshot repositories.
```json
```

Then use the get snapshot API to get a list of snapshots in a specific repository. This also returns each snapshot’s contents.
```json
```


## Restore an index or data stream

You can restore a snapshot using Kibana’s Snapshot and Restore feature or the restore snapshot API.
By default, a restore request attempts to restore all regular indices and regular data streams in a snapshot. In most cases, you only need to restore a specific index or data stream from a snapshot. However, you can’t restore an existing open index.
If you’re restoring data to a pre-existing cluster, use one of the following methods to avoid conflicts with existing indices and data streams:
- [Delete and restore](#delete-restore)
- [Rename on restore](#rename-on-restore)


### Delete and restore

The simplest way to avoid conflicts is to delete an existing index or data stream before restoring it. To prevent the accidental re-creation of the index or data stream, we recommend you temporarily stop all indexing until the restore operation is complete.
<warning>
  If the `action.destructive_requires_name` cluster setting is false, don’t use the `delete index` API to target the `*` or `.*` wildcard pattern. If you use Elasticsearch’s security features, this will delete system indices required for authentication. Instead, target the `*`,`-`.`*` wildcard pattern to exclude these system indices and other index names that begin with a dot `(.)`.
</warning>

```sh
# Delete an index
DELETE my-index

# Delete a data stream
DELETE _data_stream/logs-my_app-default
```

In the restore request, explicitly specify any indices and data streams to restore.
```json

{
  "indices": "my-index,logs-my_app-default"
}
```


### Rename on restore

If you want to avoid deleting existing data, you can instead rename the indices and data streams you restore. You typically use this method to compare existing data to historical data from a snapshot. For example, you can use this method to review documents after an accidental update or deletion.
Before you start, ensure the cluster has enough capacity for both the existing and restored data.
The following restore snapshot API request prepends `restored-` to the name of any restored index or data stream.
```json

{
  "indices": "my-index,logs-my_app-default",
  "rename_pattern": "(.+)",
  "rename_replacement": "restored-$1"
}
```

If the rename options produce two or more indices or data streams with the same name, the restore operation fails.
If you rename a data stream, its backing indices are also renamed. For example, if you rename the `logs-my_app-default` data stream to `restored-logs-my_app-default`, the backing index `.ds-logs-my_app-default-2099.03.09-000005` is renamed to `.ds-restored-logs-my_app-default-2099.03.09-000005`.
When the restore operation is complete, you can compare the original and restored data. If you no longer need an original index or data stream, you can delete it and use a [reindex](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-reindex) to rename the restored one.
```json
# Delete the original index


# Reindex the restored index to rename it

{
  "source": {
    "index": "restored-my-index"
  },
  "dest": {
    "index": "my-index"
  }
}

# Delete the original data stream


# Reindex the restored data stream to rename it

{
  "source": {
    "index": "restored-logs-my_app-default"
  },
  "dest": {
    "index": "logs-my_app-default",
    "op_type": "create"
  }
}
```


## Restore a feature state

You can restore a [feature state](/docs/deploy-manage/tools/snapshot-and-restore#feature-state) to recover system indices, system data streams, and other configuration data for a feature from a snapshot.
If you restore a snapshot’s cluster state, the operation restores all feature states in the snapshot by default. Similarly, if you don’t restore a snapshot’s cluster state, the operation doesn’t restore any feature states by default. You can also choose to restore only specific feature states from a snapshot, regardless of the cluster state.
Feature backing indices are version dependent. To see which indices are included within a snapshot's feature state, [list an applicable snapshot](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-snapshot-get). For example, on Elastic Cloud Hosted you might poll its latest snapshot on its built-in  `cloud-snapshot-policy` SLM policy:
```json
```

The response’s `feature_states` property contains a list of features in the snapshot as well as each feature’s indices. The following is an example of the output that might display for a cluster:
```json
{
  "snapshots": [
    {
      "feature_states": [
        {
          "feature_name": "security",
          "indices": [".security-tokens-7",".security-7",".security-profile-8"]
        },
        {
          "feature_name": "geoip",
          "indices": [".geoip_databases"]
        },
        {
          "feature_name": "async_search",
          "indices": [".async-search"]
        },
        {
          "feature_name": "searchable_snapshots",
          "indices": [".snapshot-blob-cache"]
        },
        {
          "feature_name": "transform",
          "indices": [".transform-internal-007"]
        },
        {
          "feature_name": "inference_plugin",
          "indices": [".secrets-inference",".inference"]
        },
        {
          "feature_name": "kibana",
          "indices": [
            ".kibana_usage_counters_9.x.x_001",
            ".kibana_9.x.x_001",
            ".apm-custom-link",
            ".kibana_search_solution_9.x.x_001",
            ".kibana_task_manager_9.x.x_001",
            ".apm-agent-configuration",
            ".kibana_locks-000001",
            ".kibana_security_session_1",
            ".kibana_alerting_cases_9.x.x_001",
            ".kibana_analytics_9.x.x_001",
            ".kibana_security_solution_9.x.x_001",
            ".kibana_ingest_9.x.x_001"
          ]
        }
      ]
    }
  ]
}
```

To restore a specific feature state from the snapshot, specify the `feature_name` from the response in the [restore snapshot API’s](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-snapshot-restore) `feature_states` parameter.
Note that feature state names may match Kibana UI sections, but restoring a single feature state may not fully reset that UI. For example, the Fleet UI depends on the `fleet` feature state as well as `kibana` and `security`. When restoring, it's important to include all required feature states in the `feature_states` parameter to achieve the desired reset behavior.
<warning>
  Restoring the `security` feature state overwrites system indices used for authentication. If you use Elastic Cloud Hosted or Elastic Cloud Enterprise, ensure you have access to the [Elasticsearch API console](https://www.elastic.co/docs/reference/cloud/cloud-hosted/ec-api-console) before restoring the `security` feature state. If you run Elasticsearch on your own hardware or in Elastic Cloud on Kubernetes, [create a temporary user with elevated permissions to edit restricted indices in the file realm](https://www.elastic.co/docs/troubleshoot/elasticsearch/file-based-recovery) to ensure you’ll still be able to access your cluster.
</warning>

When you restore a feature state, Elasticsearch closes and overwrites the feature’s existing indices and data streams. For example, to [snapshot restore](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-snapshot-restore) the `geoip` feature state, you might use:
```json

{
  "feature_states": [ "geoip" ],
  "include_global_state": false,    <1>
  "indices": "-*"                   <2>
}
```


## Restore an entire cluster

In some cases, you need to restore an entire cluster from a snapshot, including the cluster state and all [feature states](/docs/deploy-manage/tools/snapshot-and-restore#feature-state). These cases should be rare, such as in the event of a catastrophic failure.
<important>
  Restoring an entire cluster, including the cluster state and all feature states, requires that the snapshot being restored was originally created with both the cluster state and feature states included.
</important>

Restoring an entire cluster involves deleting important system indices, including those used for authentication. Consider whether you can restore specific indices or data streams instead.
If you’re restoring to a different cluster, see [Restore to a different cluster](#restore-different-cluster) before you start.
1. If you [backed up the cluster’s configuration files](/docs/deploy-manage/tools/snapshot-and-restore/create-snapshots#back-up-config-files), you can restore them to each node. This step is optional and requires a [full cluster restart](https://www.elastic.co/docs/deploy-manage/maintenance/start-stop-services/full-cluster-restart-rolling-restart-procedures).
   After you shut down a node, copy the backed-up configuration files over to the node’s `$ES_PATH_CONF` directory. Before restarting the node, ensure [`elasticsearch.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) contains the appropriate node roles, node name, and other node-specific settings.
   If you choose to perform this step, you must repeat this process on each node in the cluster.
2. Temporarily stop indexing and turn off the following features:
   - GeoIP database downloader and ILM history store
  ```json

  {
    "persistent": {
      "ingest.geoip.downloader.enabled": false,
      "indices.lifecycle.history_index_enabled": false
    }
  }
  ```
- ILM
  ```json
  ```
- Machine Learning
  ```json
  ```
- Monitoring
  ```json

  {
    "persistent": {
      "xpack.monitoring.collection.enabled": false
    }
  }
  ```
- Watcher
  ```json
  ```
- Universal Profiling
  Check if Universal Profiling index template management is enabled:
  ```json
  ```
  If the value is `true`, disable Universal Profiling index template management:
  ```json

  {
    "persistent": {
      "xpack.profiling.templates.enabled": false
    }
  }
  ```
3. If you use Elasticsearch security features, follow [File-based access recovery](https://www.elastic.co/docs/troubleshoot/elasticsearch/file-based-recovery) to temporarily create a user with temporary elevated permissions to edit restricted indices. Use this file realm user to authenticate requests until the restore operation is complete.
4. Use the [cluster update settings API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-put-settings) to set [`action.destructive_requires_name`](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/index-management-settings#action-destructive-requires-name) to `false`. This lets you delete data streams and indices using wildcards.
   ```json

   {
     "persistent": {
       "action.destructive_requires_name": false
     }
   }
   ```
5. Delete all existing data streams on the cluster.
   ```json
   ```
6. Delete all existing indices on the cluster.
   ```json
   ```
7. Restore the entire snapshot, including the cluster state. By default, restoring the cluster state also restores any feature states in the snapshot.
   ```json

   {
     "indices": "*",
     "include_global_state": true
   }
   ```
8. When the restore operation is complete, resume indexing and restart any features you stopped:
   <note>
   When the snapshot is restored, the license that was in use at the time the snapshot was taken will be restored as well. If your license has expired since the snapshot was taken, you will need to use the [Update License API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-license-post) to install a current license.
   </note>
   - GeoIP database downloader and ILM history store
  ```json

  {
    "persistent": {
      "ingest.geoip.downloader.enabled": true,
      "indices.lifecycle.history_index_enabled": true
    }
  }
  ```
- ILM
  ```json
  ```
- Machine Learning
  ```json
  ```
- Monitoring
  ```json

  {
    "persistent": {
      "xpack.monitoring.collection.enabled": true
    }
  }
  ```
- Watcher
  ```json
  ```
- Universal Profiling
  If the value was `true` initially, enable Universal Profiling index template management again, otherwise skip this step:
  ```json

  {
    "persistent": {
      "xpack.profiling.templates.enabled": true
    }
  }
  ```
9. If wanted, reset the `action.destructive_requires_name` cluster setting.
   ```json

   {
     "persistent": {
       "action.destructive_requires_name": null
     }
   }
   ```


## Monitor a restore

The restore operation uses the [shard recovery process](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-recovery) to restore an index’s primary shards from a snapshot. While the restore operation recovers primary shards, the cluster will have a `yellow` [health status](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-health).
After all primary shards are recovered, the replication process creates and distributes replicas across eligible data nodes. When replication is complete, the cluster health status typically becomes `green`.
Once you start a restore in Kibana, you’re navigated to the **Restore Status** page. You can use this page to track the current state for each shard in the snapshot.
You can also monitor snapshot recover using Elasticsearch APIs. To monitor the cluster health status, use the [cluster health API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-health).
```json
```

To get detailed information about ongoing shard recoveries, use the [index recovery API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-recovery).
```json
```

To view any unassigned shards, use the [cat shards API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cat-shards).
```json
```

Unassigned shards have a `state` of `UNASSIGNED`. The `prirep` value is `p` for primary shards and `r` for replicas. The `unassigned.reason` describes why the shard remains unassigned.
To get a more in-depth explanation of an unassigned shard’s allocation status, use the [cluster allocation explanation API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-allocation-explain).
```json

{
  "index": "my-index",
  "shard": 0,
  "primary": false,
  "current_node": "my-node"
}
```


## Cancel a restore

You can delete an index or data stream to cancel its ongoing restore. This also deletes any existing data in the cluster for the index or data stream. Deleting an index or data stream doesn’t affect the snapshot or its data.
```json
# Delete an index


# Delete a data stream
```


## Restore to a different cluster

<tip>
  Elastic Cloud Hosted and Elastic Cloud Enterprise can help you restore snapshots from other deployments. Refer to [Restore a snapshot across clusters](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/ece-restore-across-clusters) for more information.
</tip>

Snapshots aren’t tied to a particular cluster or a cluster name. You can create a snapshot in one cluster and restore it in another [compatible cluster](/docs/deploy-manage/tools/snapshot-and-restore#snapshot-restore-version-compatibility). Any data stream or index you restore from a snapshot must also be compatible with the current cluster’s version. The topology of the clusters doesn’t need to match.
To restore a snapshot, its repository must be [registered](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/self-managed) and available to the new cluster. If the original cluster still has write access to the repository, register the repository as read-only. This prevents multiple clusters from writing to the repository at the same time and corrupting the repository’s contents. It also prevents Elasticsearch from caching the repository’s contents, which means that changes made by other clusters will become visible straight away.
Before you start a restore operation, ensure the new cluster has enough capacity for any data streams or indices you want to restore. If the new cluster has a smaller capacity, you can:
- Add nodes or upgrade your hardware to increase capacity.
- Restore fewer indices and data streams.
- Reduce the [number of replicas](https://www.elastic.co/docs/reference/elasticsearch/index-settings/index-modules#dynamic-index-number-of-replicas) for restored indices.
  For example, the following restore snapshot API request uses the `index_settings` option to set `index.number_of_replicas` to `1`.
  ```json

  {
    "indices": "my-index,logs-my_app-default",
    "index_settings": {
      "index.number_of_replicas": 1
    }
  }
  ```

If indices or backing indices in the original cluster were assigned to particular nodes using [shard allocation filtering](https://www.elastic.co/docs/deploy-manage/distributed-architecture/shard-allocation-relocation-recovery/index-level-shard-allocation), the same rules will be enforced in the new cluster. If the new cluster does not contain nodes with appropriate attributes that a restored index can be allocated on, the index will not be successfully restored unless these index allocation settings are changed during the restore operation.
The restore operation also checks that restored persistent settings are compatible with the current cluster to avoid accidentally restoring incompatible settings. If you need to restore a snapshot with incompatible persistent settings, try restoring it without the [global cluster state](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-snapshot-restore).

## Troubleshoot restore errors

Here’s how to resolve common errors returned by restore requests.

### Cannot restore index [<index>] because an open index with same name already exists in the cluster

You can’t restore an open index that already exists. To resolve this error, try one of the methods in [Restore an index or data stream](#restore-index-data-stream).

### Cannot restore index [<index>] with [x] shards from a snapshot of index [<snapshot-index>] with [y] shards

You can only restore an existing index if it’s closed and the index in the snapshot has the same number of primary shards. This error indicates the index in the snapshot has a different number of primary shards.
To resolve this error, try one of the methods in [Restore an index or data stream](#restore-index-data-stream).