﻿---
title: Repository isolation on AWS and GCP
description: Deployments of your organization in the same region currently may have access to each other’s snapshots via the Elastic provided found-snapshots repository...
url: https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/repository-isolation-on-aws-gcp
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Repository isolation on AWS and GCP
<note>
  This configuration is automatic for all newly created deployments, but may be necessary for some existing deployments you have. If a deployment is not yet using an isolated snapshot repository, a notification will show up in the deployments menu under **Elasticsearch** > **Snapshots**.
</note>

Deployments of your organization in the same region currently may have access to each other’s snapshots via the Elastic provided `found-snapshots` repository. For improved security between deployments, each deployment should only have access to its own snapshots.
If a deployment can still access the snapshots of other deployments, a notification will show up in the deployments menu under **Elasticsearch** > **Snapshots**. After applying the action, the notification will disappear.

## Removing a repository of another deployment

The deployment may have access to other deployments if it has been restored from a snapshot. If this is the case, the access permissions will be listed under **Elasticsearch** > **Snapshots** under the title **Snapshot repositories of other deployments**.
If you no longer need access to the snapshot of another deployment, you can remove the access. By doing this, you prevent accessing snapshots of other deployments from this deployment:
1. From your deployment menu, go to **Elasticsearch** > **Snapshots**.
2. On the **Snapshots** page, **Snapshot repositories of other deployments** shows the old repository.
3. With **Remove Access**, the snapshot repository will be removed.

<note>
  If the repository is still in use (for example by mounted searchable snapshots), it can’t be removed. Remove any indices stored in this repository first.
</note>

![View of the old snapshot repository in the Cloud UI](https://www.elastic.co/docs/deploy-manage/images/cloud-ec-elasticsearch-snapshots-of-other-deployments-aws-gcp.png)