﻿---
title: Read-only URL repository
description: You can use a URL repository to give a cluster read-only access to a shared file system. Since URL repositories are always read-only, they’re a safer...
url: https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/read-only-url-repository
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Read-only URL repository
<note>
  This repository type is only available if you run Elasticsearch on your own hardware. If you use Elastic Cloud Hosted, see [Elastic Cloud Hosted repository types](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/self-managed).
</note>

You can use a URL repository to give a cluster read-only access to a shared file system. Since URL repositories are always read-only, they’re a safer and more convenient alternative to registering a read-only shared filesystem repository.
Use Kibana or the [create snapshot repository API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-snapshot-create-repository) to register a URL repository.
```json

{
  "type": "url",
  "settings": {
    "url": "file:/mount/backups/my_fs_backup_location"
  }
}
```


## Repository settings

<definitions>
  <definition term="chunk_size">
    (Optional, [byte value](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/api-conventions#byte-units)) Maximum size of files in snapshots. In snapshots, files larger than this are broken down into chunks of this size or smaller. Defaults to `null` (unlimited file size).
  </definition>
  <definition term="http_max_retries">
    (Optional, integer) Maximum number of retries for `http` and `https` URLs. Defaults to `5`.
  </definition>
  <definition term="http_socket_timeout">
    (Optional, [time value](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/api-conventions#time-units)) Maximum wait time for data transfers over a connection. Defaults to `50s`.
  </definition>
  <definition term="compress">
    (Optional, Boolean) If `true`, metadata files, such as index mappings and settings, are compressed in snapshots. Data files are not compressed. Defaults to `true`.
  </definition>
  <definition term="max_number_of_snapshots">
    (Optional, integer) Maximum number of snapshots the repository can contain. Defaults to `Integer.MAX_VALUE`, which is `2`^`31`^`-1` or `2147483647`.
  </definition>
  <definition term="max_restore_bytes_per_sec">
    (Optional, [byte value](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/api-conventions#byte-units)) Maximum snapshot restore rate per node. Defaults to unlimited. Note that restores are also throttled through [recovery settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/index-recovery-settings).
  </definition>
  <definition term="max_snapshot_bytes_per_sec">
    (Optional, [byte value](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/api-conventions#byte-units)) Maximum snapshot creation rate per node. Defaults to `40mb` per second. Note that if the [recovery settings for managed services](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/index-recovery-settings#recovery-settings-for-managed-services) are set, then it defaults to unlimited, and the rate is additionally throttled through [recovery settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/index-recovery-settings).
  </definition>
  <definition term="url">
    (Required, string) URL location of the root of the shared filesystem repository. The following protocols are supported:
    - `file`
    - `ftp`
    - `http`
    - `https`
    - `jar`
    URLs using the `http`, `https`, or `ftp` protocols must be explicitly allowed with the [`repositories.url.allowed_urls`](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/snapshot-restore-settings#repositories-url-allowed) cluster setting. This setting supports wildcards in the place of a host, path, query, or fragment in the URL.
    URLs using the `file` protocol must point to the location of a shared filesystem accessible to all master and data nodes in the cluster. This location must be registered in the `path.repo` setting, in the same way as when configuring a [shared filesystem repository](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/shared-file-system-repository), and it must contain the snapshot data. You don’t need to set `path.repo` when using URLs with the `ftp`, `http`, `https`, or `jar` protocols.
  </definition>
</definitions>