﻿---
title: Manage snapshot repositories
description: Snapshot repositories allow you to back up and restore your Elasticsearch data efficiently. Whether you're using Elastic Cloud Hosted, Elastic Cloud Enterprise...
url: https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/manage-snapshot-repositories
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Manage snapshot repositories
Snapshot repositories allow you to back up and restore your Elasticsearch data efficiently. Whether you're using [Elastic Cloud Hosted](#elastic-cloud-hosted), [Elastic Cloud Enterprise (ECE)](#elastic-cloud-enterprise), [Elastic Cloud on Kubernetes (ECK)](#elastic-cloud-on-kubernetes), or managing your own [Elasticsearch cluster](#self-managed), configuring a snapshot repository ensures data security, long-term archiving, and seamless migration across environments.

## Supported repository types


### Self-managed

If you manage your own Elasticsearch cluster, you can use the following built-in snapshot repository types:
- [Azure](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/azure-repository)
- [Google Cloud Storage](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/google-cloud-storage-repository)
- [AWS S3](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/s3-repository)
- [Shared file system](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/shared-file-system-repository)
- [Read-only URL](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/read-only-url-repository)
- [Source-only](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/source-only-repository)

Other repository types are available through official plugins:
- [Hadoop Distributed File System (HDFS)](https://www.elastic.co/docs/reference/elasticsearch/plugins/repository-hdfs)


### Elastic Cloud Hosted

Elastic Cloud Hosted deployments automatically register a repository named `found-snapshots` in Elasticsearch clusters. These repositories are used together with the `cloud-snapshot-policy` SLM policy to take periodic snapshots of your Elasticsearch clusters. You can also use the `found-snapshots` repository for your own [SLM policies](/docs/deploy-manage/tools/snapshot-and-restore/create-snapshots#automate-snapshots-slm) or to store searchable snapshots.
The `found-snapshots` repository is specific to each deployment. However, you can restore snapshots from another deployment’s found-snapshots repository if the deployments are under the same account and in the same region.
In addition to the platform-managed `found-snapshots` repository, you can register custom snapshot repositories in Elastic Cloud Hosted deployments of the following types:
- [Azure](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/ec-azure-snapshotting)
- [Google Cloud Storage](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/ec-gcs-snapshotting)
- [AWS S3](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/ec-aws-custom-repository)
- [Source-only](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/source-only-repository)

For more details, refer to [Registering snapshot repositories in Elastic Cloud Hosted](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/elastic-cloud-hosted).

### Elastic Cloud Enterprise (ECE)

Snapshot repositories are managed at the platform level in Elastic Cloud Enterprise (ECE) and can be associated with deployments as needed. ECE supports the creation and maintenance of multiple repositories, but each deployment can be linked to only one repository for automatic snapshots.
When a platform-level repository is associated with a deployment, the `found-snapshots` repository is added to the Elasticsearch cluster, and, similar to Elastic Cloud Hosted, a snapshot is taken every 30 minutes by default. The interval can be adjusted on per deployment basis.
Elastic Cloud Enterprise installations support the following Elasticsearch snapshot repository types:
- [AWS S3](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/ece-aws-custom-repository)
- [Azure](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/azure-storage-repository)
- [Google Cloud Storage](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/google-cloud-storage-gcs-repository)
- [MinIO](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/minio-on-premise-repository)

<note>
  No repository types other than those listed are supported in the Elastic Cloud Enterprise platform, even if they are supported by Elasticsearch.
</note>

For more details, refer to [Managing snapshot repositories in Elastic Cloud Enterprise](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/cloud-enterprise).
In addition to the platform-managed repositories, you can also register snapshot repositories directly at the deployment level for custom or deployment-specific use cases. For this, follow [the Elastic Cloud Hosted guides](#elastic-cloud-hosted), which are also applicable to Elastic Cloud Enterprise deployments.

### Elastic Cloud on Kubernetes (ECK)

Elasticsearch clusters deployed through ECK support the same type of deployments as self-managed Elasticsearch clusters. ECK does not currently provide any automation or functionality to facilitate the integration of snapshot repositores within the Elasticsearch clusters.
For more information and examples, refer to [create automated snapshots on ECK](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/cloud-on-k8s).