﻿---
title: Configure a Google Cloud Storage snapshot repository in Elastic Cloud Enterprise
description: This guide focuses on registering a Google Cloud Storage (GCS) snapshot repository at the Elastic Cloud Enterprise (ECE) platform level. Platform-level...
url: https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/google-cloud-storage-gcs-repository
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Configure a Google Cloud Storage snapshot repository in Elastic Cloud Enterprise
This guide focuses on registering a Google Cloud Storage (GCS) snapshot repository at the Elastic Cloud Enterprise (ECE) platform level. Platform-level repositories can be assigned to deployments and are used by ECE to automatically manage snapshots through the `found-snapshots` repository.
If you have custom requirements or deployment-specific use cases that are independent of the ECE-managed automation, you can also register snapshot repositories directly at the deployment level. To do that, follow the [Elastic Cloud Hosted guide for Google Cloud Storage](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/ec-gcs-snapshotting), which is also applicable to Elastic Cloud Enterprise deployments.
At ECE platform level, snapshots to Google Cloud Storage (GCS) are supported using an [advanced repository configuration](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/cloud-enterprise) and service account credentials that can administer your GCS bucket.

## Set up your service account credentials

You’ll need to have an existing Google Cloud account and have the appropriate permissions to generate credentials:
1. Create [service account credentials](https://cloud.google.com/iam/docs/creating-managing-service-account-keys) in your Google Cloud project where Elastic Cloud Enterprise is running.
   The service account should be [granted the role of `storage.admin`](https://cloud.google.com/iam/docs/granting-roles-to-service-accounts) so that Elasticsearch clusters can read, write, and list the bucket objects.
2. Save the service account key in JSON file format. You are going to use it later to configure your Elasticsearch deployment for snapshotting.


## Add the GCS repository

Add your Google Cloud Storage bucket as a repository to the platform:
1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
2. Go to **Platform > Repositories** and add the following snapshot repository configuration under the advanced mode:
   Repository GCS (check: [supported settings](/docs/deploy-manage/tools/snapshot-and-restore/google-cloud-storage-repository#repository-gcs-repository))
   ```json
   {
     "type": "gcs",
     "settings": {
       "bucket": "acme-snapshot-repo",
       "client": "acme-snapshots"
     }
   }
   ```

Snapshots are stored in the bucket you provide. Use the repository name you define here to configure your Elasticsearch clusters for snapshotting to this repository.

## Configure your deployment for GCS snapshots

To save deployment snapshots to the custom GCS repository:
1. Add a [secure setting](https://www.elastic.co/docs/deploy-manage/security/secure-settings) named `gcs.client.acme-snapshots.credentials_file` as a JSON block. Make sure that the client name is the same one you provided when configuring the snapshot repository.
   ![GCS client secret configuration](https://www.elastic.co/docs/deploy-manage/images/cloud-enterprise-ece-secure-settings.png)
   <note>
   The contents within *credentials_file* must be the exact contents of your GCS credentials file.
   </note>
2. Configure your deployment to [snapshot to the GCS repository](/docs/deploy-manage/tools/snapshot-and-restore/cloud-enterprise#ece-manage-repositories-clusters).

After you enable snapshots, snapshotting will begin within 30 minutes (the default snapshot interval).