﻿---
title: Configure an AWS S3 snapshot repository in Elastic Cloud Enterprise
description: This guide focuses on registering an AWS S3 snapshot repository at the Elastic Cloud Enterprise (ECE) platform level. Platform-level repositories can...
url: https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/ece-aws-custom-repository
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Configure an AWS S3 snapshot repository in Elastic Cloud Enterprise
This guide focuses on registering an AWS S3 snapshot repository at the Elastic Cloud Enterprise (ECE) platform level. Platform-level repositories can be assigned to deployments and are used by ECE to automatically manage snapshots through the `found-snapshots` repository.
If you have custom requirements or deployment-specific use cases that are independent of the ECE-managed automation, you can also register snapshot repositories directly at the deployment level. To do that, follow the [Elastic Cloud Hosted guide for AWS S3](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/ec-aws-custom-repository), which is also applicable to Elastic Cloud Enterprise deployments.

## Add the AWS S3 repository

To add the repository:
1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
2. From the **Platform** menu, select **Repositories**.
3. Select **Add Repository** to add an existing repository.
4. Provide a name for the repository configuration.
   ECE Snapshot Repository names are now required to meet the same standards as S3 buckets. Refer to the official AWS documentation on [Bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html).
5. Select one of the supported repository types and specify the necessary settings:
   - Amazon S3 configuration:
  All repository options must be specified, as there are no default values.
  <definitions>
  <definition term="Region">
  The region where the bucket is located.
  </definition>
  <definition term="Bucket">
  The name of the bucket to be used for snapshots.
  </definition>
  <definition term="Access key">
  The access key to use for authentication.
  </definition>
  <definition term="Secret key">
  The secret key to use for authentication.
  </definition>
  </definitions>
- Advanced configuration:
  Used for Microsoft Azure, Google Cloud Platform, or for some Amazon S3 repositories where you need to provide additional configuration parameters not supported by the S3 repository option. Configurations must be specified in a valid JSON format. For example:
  Amazon S3 (check [supported settings](/docs/deploy-manage/tools/snapshot-and-restore/s3-repository#repository-s3-repository)):
  ```json
  {
    "type": "s3",
    "settings": {
      "bucket": "my_bucket_name",
      "region": "us-west"
    }
  }
  ```
  <note>
  Don’t set `base_path` when configuring a snapshot repository for Elastic Cloud Enterprise. Elastic Cloud Enterprise automatically generates the `base_path` for each deployment so that multiple deployments may share the same bucket.
  </note>
6. Select **Save**.


## Configure your deployment to use the repository

After adding the snapshot repository, [configure your deployment to use it](/docs/deploy-manage/tools/snapshot-and-restore/cloud-enterprise#ece-manage-repositories-clusters). Once configured, snapshots run automatically according to the scheduled interval. You can update this schedule from the **Snapshots** section in the **Elasticsearch** menu of your deployment page.