﻿---
title: Configure a GCS snapshot repository in ECH and ECE
description: Configure a custom snapshot repository using your Google Cloud Storage account. You’ll need to have an existing Google Cloud account and have the appropriate...
url: https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/ec-gcs-snapshotting
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud Enterprise: Generally available
---

# Configure a GCS snapshot repository in ECH and ECE
Configure a custom snapshot repository using your Google Cloud Storage account.
<note>
  This procedure can be used for both Elastic Cloud Hosted and Elastic Cloud Enterprise deployments to register a snapshot repository directly at the deployment level. This is useful when you need a deployment-specific repository that operates independently of the [platform-managed automatic snapshots](/docs/deploy-manage/tools/snapshot-and-restore/manage-snapshot-repositories#elastic-cloud-hosted) (`found-snapshots`), for example for [searchable snapshots](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/searchable-snapshots) or custom backup use cases.For platform-level repositories configuration in Elastic Cloud Enterprise, refer to [Manage snapshot repositories in Elastic Cloud Enterprise](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/cloud-enterprise).
</note>


## Set up your service account credentials

You’ll need to have an existing Google Cloud account and have the appropriate permissions to generate credentials.
1. Create a [service account key](https://cloud.google.com/iam/docs/creating-managing-service-account-keys) in your Google Cloud project.
   The service account should be configured to have permission to read, write, and list the bucket objects. For more information, refer to [Recommended bucket permission](/docs/deploy-manage/tools/snapshot-and-restore/google-cloud-storage-repository#repository-gcs-bucket-permission) in the Elasticsearch docs.
2. Save the service account key in JSON file format. You are going to use it later to configure your Elasticsearch deployment for snapshotting.

For more detailed information on the JSON account service key, refer to [Using a Service Account](/docs/deploy-manage/tools/snapshot-and-restore/google-cloud-storage-repository#repository-gcs-using-service-account).

## Prepare a bucket

Follow the Google Cloud Storage documentation to [create a GCS bucket](https://cloud.google.com/storage/docs/creating-buckets).

## Configure the keystore

Create an entry for the GCS client in the Elasticsearch keystore:
1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
2. Navigate to the **Security** page of the deployment you wish to configure.
3. Locate **Elasticsearch keystore** and select **Add settings**.
4. Enter the **Setting name** `gcs.client.secondary.credentials_file`.
5. With **Type** set to **JSON block / file**, add your [GCS service account key JSON file](#ec-gcs-service-account-key).
6. Select **Save**.


## Create the repository

1. Open Kibana and go to **Management** > **Snapshot and Restore**.
2. On the **Repositories** tab, select **Register a repository**.
3. Provide a name for your repository and select type **Google Cloud Storage**.
4. Provide the following settings:
   - Client: `secondary`
- Bucket: Your GCS bucket name
- Base path: A directory to contain the snapshots
  - This setting is optional. Include a `base_path` if you have multiple clusters writing to the same GCS repository. This ensures that a snapshot won’t overwrite the snapshot metadata for another cluster.
5. Add any other settings that you wish to configure.
6. Select **Register**.
7. Select **Verify** to confirm that your settings are correct and the deployment can connect to your repository.

Your snapshot repository is now set up using GCS! You can use Kibana to manage your snapshots and begin sending Elasticsearch snapshots to your own bucket. For details, check the [Snapshot and Restore](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/create-snapshots) documentation.