﻿---
title: Configure an Azure Blob Storage snapshot repository in ECH and ECE
description: Configure a custom snapshot repository using your Azure Blob Storage account. Follow the Microsoft documentation to set up an Azure storage account with...
url: https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/ec-azure-snapshotting
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud Enterprise: Generally available
---

# Configure an Azure Blob Storage snapshot repository in ECH and ECE
Configure a custom snapshot repository using your Azure Blob Storage account.
<note>
  This procedure can be used for both Elastic Cloud Hosted and Elastic Cloud Enterprise deployments to register a snapshot repository directly at the deployment level. This is useful when you need a deployment-specific repository that operates independently of the [platform-managed automatic snapshots](/docs/deploy-manage/tools/snapshot-and-restore/manage-snapshot-repositories#elastic-cloud-hosted) (`found-snapshots`), for example for [searchable snapshots](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/searchable-snapshots) or custom backup use cases.For platform-level repositories configuration in Elastic Cloud Enterprise, refer to [Manage snapshot repositories in Elastic Cloud Enterprise](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/cloud-enterprise).
</note>


## Prepare a container

Follow the Microsoft documentation to [set up an Azure storage account](https://docs.microsoft.com/en-us/azure/storage/common/storage-account-create) with an access key, and then [create a container](https://docs.microsoft.com/en-us/azure/storage/blobs/storage-quickstart-blobs-portal).

## Configure the keystore

Create an entry for the Azure client in the Elasticsearch keystore:
1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
2. Navigate to the **Security** page of the deployment you wish to configure.
3. Locate **Elasticsearch keystore** and select **Add settings**.
4. With **Type** set to **Single string**, add the following keys and their values:
   - `azure.client.secondary.account`
- `azure.client.secondary.key`
5. Select **Save**.


## Create the repository

1. Open Kibana and go to **Management** > **Snapshot and Restore**.
2. On the **Repositories** tab, select **Register a repository**.
3. Provide a name for your repository and select type **Azure**.
4. Provide the following settings:
   - Client: `secondary`
  - You can also use `default`, but we recommend using `secondary` to ensure that your secure settings are mapped to the correct repository definition.
- Container: The name of your Azure container
- base_path: A directory to contain the snapshots
  - This setting is optional. Include a `base_path` if you have multiple clusters writing to the same Azure repository. This ensures that a snapshot won’t overwrite the snapshot metadata for another cluster.
5. Add any other settings that you wish to configure.
6. Select Register.
7. Select **Verify** to confirm that your settings are correct and the deployment can connect to your repository.

Your snapshot repository is now set up using Azure Blob storage! You can use Kibana to manage your snapshots and begin sending Elasticsearch snapshots to your own container. For details, check the [Snapshot and Restore](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/create-snapshots) documentation.