﻿---
title: Configure an AWS S3 snapshot repository in ECH and ECE
description: Configure a custom snapshot repository using an S3 storage bucket in your AWS account. Create the S3 bucket in your custom AWS account. Make sure to reserve...
url: https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/ec-aws-custom-repository
products:
  - Elastic Cloud Hosted
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud Enterprise: Generally available
---

# Configure an AWS S3 snapshot repository in ECH and ECE
Configure a custom snapshot repository using an S3 storage bucket in your AWS account.
<note>
  This procedure can be used for both Elastic Cloud Hosted and Elastic Cloud Enterprise deployments to register a snapshot repository directly at the deployment level. This is useful when you need a deployment-specific repository that operates independently of the [platform-managed automatic snapshots](/docs/deploy-manage/tools/snapshot-and-restore/manage-snapshot-repositories#elastic-cloud-hosted) (`found-snapshots`), for example for [searchable snapshots](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/searchable-snapshots) or custom backup use cases.For platform-level repositories configuration in Elastic Cloud Enterprise, refer to [Manage snapshot repositories in Elastic Cloud Enterprise](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/cloud-enterprise).
</note>


## Prepare an S3 bucket

Create the S3 bucket in your custom AWS account. Make sure to reserve this bucket to backup only one cluster, since AWS allows file overwrite for non-unique titles.
Next, create an IAM user, copy the access key ID and secret, and configure the following user policy. This is important to make sure the access keys, which you will need to provide to your cluster, can only access the intended bucket.
```json
{
  "Version": "policy-language-YYYY-MM-dd",<1>
  "Statement": [
    {
      "Action": [
        "s3:*"
      ],
      "Effect": "Allow",
      "Resource": [
        "arn:aws:s3:::bucket-name",
        "arn:aws:s3:::bucket-name/*"
      ]
    }
  ]
}
```

1. The version of the policy language syntax rules. For more information, refer to the [AWS documentation](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-reference-policy-checks.html#access-analyzer-reference-policy-checks-error-invalid-version).

For more information on S3 and IAM, refer to AWS' [S3-documentation](http://docs.aws.amazon.com/AmazonS3/latest/dev/Introduction.html) and [IAM-documentation](http://aws.amazon.com/documentation/iam/).
<note>
  For a full list of settings that are supported for your S3 bucket, refer to [S3 repository](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/s3-repository) in the Elasticsearch Guide.
</note>


## Store your secrets in the keystore

You can use the Elasticsearch keystore to store the credentials to access your AWS account.
1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
2. Navigate to the **Security** page of the deployment you wish to configure.
3. Locate **Elasticsearch keystore** and select **Add settings**.
4. With **Type** set to **Single string**, add the following keys and their values:
   - `s3.client.secondary.access_key`
- `s3.client.secondary.secret_key`
5. Perform a cluster restart to [reload the secure settings](/docs/deploy-manage/security/secure-settings#ec-add-secret-values).


## Create the repository

1. Open Kibana and go to **Management** > **Snapshot and Restore**.
2. On the **Repositories** tab, select **Register a repository**.
3. Provide a name for your repository and select type **AWS S3**.
4. Provide the following settings:
   - Client: `secondary`
- Bucket: `YOUR_S3_BUCKET_NAME`
5. Add any other settings that you wish to configure.
6. Select **Register**.
7. Select **Verify** to confirm that your settings are correct and the deployment can connect to your repository.

Your snapshot repository is now set up using S3! You can use Kibana to manage your snapshots and begin sending Elasticsearch snapshots to your own bucket. For details refer to the [Snapshot and Restore](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/create-snapshots) documentation.