﻿---
title: Create, monitor and delete snapshots
description: This guide shows you how to create, monitor and delete snapshots of a running cluster. You can later restore a snapshot to recover or transfer its data...
url: https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/create-snapshots
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Create, monitor and delete snapshots
This guide shows you how to create, monitor and delete snapshots of a running cluster. You can later [restore a snapshot](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/restore-snapshot) to recover or transfer its data.
In this guide, you’ll learn how to:
- Automate snapshot creation and retention with snapshot lifecycle management (SLM)
- Manually take a snapshot
- Monitor a snapshot’s progress
- Delete or cancel a snapshot
- Back up cluster configuration files

The guide also provides tips for creating dedicated cluster state snapshots and taking snapshots at different time intervals.

## Prerequisites

- To use Kibana's **Snapshot and Restore** feature, you must have the following permissions:
  - [Cluster privileges](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-cluster): `monitor`, `manage_slm`, `cluster:admin/snapshot`, and `cluster:admin/repository`
- [Index privilege](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-indices): `all` on the `monitor` index
- You can only take a snapshot from a running cluster with an elected [master node](/docs/deploy-manage/distributed-architecture/clusters-nodes-shards/node-roles#master-node-role).
- A snapshot repository must be [registered](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/self-managed) and available to the cluster.
- The cluster’s global metadata must be readable. To include an index in a snapshot, the index and its metadata must also be readable. Ensure there aren’t any [cluster blocks](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/miscellaneous-cluster-settings#cluster-read-only) or [index blocks](https://www.elastic.co/docs/reference/elasticsearch/index-settings/index-block) that prevent read access.


## Considerations

- Each snapshot must have a unique name within its repository. Attempts to create a snapshot with the same name as an existing snapshot will fail.
- Snapshots are automatically deduplicated. You can take frequent snapshots with little impact to your storage overhead.
- Each snapshot is logically independent. You can delete a snapshot without affecting other snapshots.
- Taking a snapshot can temporarily pause shard allocations. See [Snapshots and shard allocation](/docs/deploy-manage/tools/snapshot-and-restore#snapshots-shard-allocation).
- Taking a snapshot doesn’t block indexing or other requests. However, the snapshot won’t include changes made after the snapshot process starts.
- You can take multiple snapshots at the same time. The [`snapshot.max_concurrent_operations`](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/snapshot-restore-settings#snapshot-max-concurrent-ops) cluster setting limits the maximum number of concurrent snapshot operations.
- If you include a data stream in a snapshot, the snapshot also includes the stream’s backing indices and metadata.
  You can also include only specific backing indices in a snapshot. However, the snapshot won’t include the data stream’s metadata or its other backing indices.
- A snapshot can include a data stream but exclude specific backing indices. When you restore such a data stream, it will contain only backing indices in the snapshot. If the stream’s original write index is not in the snapshot, the most recent backing index from the snapshot becomes the stream’s write index.


## Automate snapshots with SLM

Snapshot lifecycle management (SLM) is the easiest way to regularly back up a cluster. An SLM policy automatically takes snapshots on a preset schedule. The policy can also delete snapshots based on retention rules you define.
<tip>
  Elastic Cloud Hosted deployments automatically include the `cloud-snapshot-policy` SLM policy. Elastic Cloud Hosted uses this policy to take periodic snapshots of your cluster. For more information, see the [Manage snapshot repositories in Elastic Cloud Hosted documentation](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/elastic-cloud-hosted).
</tip>


### SLM security

The following [cluster privileges](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-cluster) control access to the SLM actions when Elasticsearch security features are enabled:
<definitions>
  <definition term="manage_slm">
    Allows a user to perform all SLM actions, including creating and updating policies and starting and stopping SLM.
  </definition>
  <definition term="read_slm">
    Allows a user to perform all read-only SLM actions, such as getting policies and checking the SLM status.
  </definition>
  <definition term="cluster:admin/snapshot/*">
    Allows a user to take and delete snapshots of any index, whether or not they have access to that index.
  </definition>
</definitions>

You can create and manage roles to assign these privileges through Kibana Management.
To grant the privileges necessary to create and manage SLM policies and snapshots, you can set up a role with the `manage_slm` and `cluster:admin/snapshot/*` cluster privileges and full access to the SLM history indices.
For example, the following request creates an `slm-admin` role:
```json

{
  "cluster": [ "manage_slm", "cluster:admin/snapshot/*" ],
  "indices": [
    {
      "names": [ ".slm-history-*" ],
      "privileges": [ "all" ]
    }
  ]
}
```

To grant read-only access to SLM policies and the snapshot history, you can set up a role with the `read_slm` cluster privilege and read access to the snapshot lifecycle management history indices.
For example, the following request creates a `slm-read-only` role:
```json

{
  "cluster": [ "read_slm" ],
  "indices": [
    {
      "names": [ ".slm-history-*" ],
      "privileges": [ "read" ]
    }
  ]
}
```


### Create an SLM policy

To manage SLM in Kibana:
1. Go to the **Snapshot and Restore** management page in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Select the **Policies** tab.
3. To create a policy, click **Create policy**.

You can also manage SLM using the [SLM APIs](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-slm). To create a policy, use the [create SLM policy API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-slm-put-lifecycle).
The following request creates a policy that backs up the cluster state, all data streams, and all indices daily at 1:30 a.m. UTC.
```json

{
  "schedule": "0 30 1 * * ?",       <1>
  "name": "<nightly-snap-{now/d}>", <2>
  "repository": "my_repository",    <3>
  "config": {
    "indices": "*",                 <4>
    "include_global_state": true    <5>
  },
  "retention": {                    <6>
    "expire_after": "30d",
    "min_count": 5,
    "max_count": 50
  }
}
```


### Manually run an SLM policy

You can manually run an SLM policy to immediately create a snapshot. This is useful for testing a new policy or taking a snapshot before an upgrade. Manually running a policy doesn’t affect its snapshot schedule.
To run a policy in Kibana, go to the **Policies** page and click the run icon under the **Actions** column. You can also use the [execute SLM policy API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-slm-execute-lifecycle).
```json
```

The snapshot process runs in the background. To monitor its progress, see [Monitor a snapshot](#monitor-snapshot).

### SLM retention

SLM snapshot retention is a cluster-level task that runs separately from a policy’s snapshot schedule. To control when the SLM retention task runs, configure the [`slm.retention_schedule`](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/snapshot-restore-settings#slm-retention-schedule) cluster setting.
```json

{
  "persistent" : {
    "slm.retention_schedule" : "0 30 1 * * ?"
  }
}
```

To immediately run the retention task, use the [execute SLM retention policy API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-slm-execute-retention).
```json
```

An SLM policy’s retention rules only apply to snapshots created using the policy. Other snapshots don’t count toward the policy’s retention limits.

### Snapshot retention limits

We recommend you include retention rules in your SLM policy to delete snapshots you no longer need.
A snapshot repository can safely scale to thousands of snapshots. However, to manage its metadata, a large repository requires more memory on the master node. Retention rules ensure a repository’s metadata doesn’t grow to a size that could destabilize the master node.

### Update an existing SLM policy

You can update an existing SLM policy after it's created. To manage SLM in Kibana:
1. Go to the **Snapshot and Restore** management page in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Select the **Policies** tab.
3. On the policy that you want to edit, click **Edit** `✎`, and make the desired change.

For example, you can change the schedule, or snapshot retention-related configurations.
![change schedule](https://www.elastic.co/docs/deploy-manage/images/elasticsearch-reference-change-slm-schedule.png)
![change snapshot retention](https://www.elastic.co/docs/deploy-manage/images/elasticsearch-reference-change-slm-snapshot-retention.png)
You can also update an SLM policy using the [SLM APIs](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-slm), as described in [Create an SLM policy](#create-slm-policy).

## Manually create a snapshot

To take a snapshot without an SLM policy, use the [create snapshot API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-snapshot-create). The snapshot name supports [date math](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/api-conventions#api-date-math-index-names).
```json
# PUT _snapshot/my_repository/<my_snapshot_{now/d}>
```

Depending on its size, a snapshot can take a while to complete. By default, the create snapshot API only initiates the snapshot process, which runs in the background. To block the client until the snapshot finishes, set the `wait_for_completion` query parameter to `true`.
```json
```

You can also clone an existing snapshot using [clone snapshot API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-snapshot-clone).

## Monitor a snapshot

To monitor any currently running snapshots, use the [get snapshot API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-snapshot-get) with the `_current` request path parameter.
```json
```

To get a complete breakdown of each shard participating in any currently running snapshots, use the [get snapshot status API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-snapshot-get).
```json
```


### Check SLM history

To get more information about a cluster’s SLM execution history, including stats for each SLM policy, use the [get SLM stats API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-slm-get-stats). The API also returns information about the cluster’s snapshot retention task history.
```json
```

To get information about a specific SLM policy’s execution history, use the [get SLM policy API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-slm-get-lifecycle). The response includes:
- The next scheduled policy execution.
- The last time the policy successfully started the snapshot process, if applicable. A successful start doesn’t guarantee the snapshot completed.
- The last time policy execution failed, if applicable, and the associated error.

```json
```


## Delete or cancel a snapshot

To delete a snapshot in Kibana, go to the **Snapshots** page and click the trash icon under the **Actions** column. To delete multiple snapshots at once, select the snapshots from the list and then click **Delete snaphshots**.
![delete snapshot](https://www.elastic.co/docs/deploy-manage/images/elasticsearch-reference-delete-snapshots.png)
You can also use the [delete snapshot API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-snapshot-delete).
```json
```

If you delete a snapshot that’s in progress, Elasticsearch cancels it. The snapshot process halts and deletes any files created for the snapshot. Deleting a snapshot doesn’t delete files used by other snapshots.

## Back up configuration files

If you run Elasticsearch on your own hardware, we recommend that, in addition to backups, you take regular backups of the files in each node’s [`$ES_PATH_CONF` directory](/docs/deploy-manage/deploy/self-managed/configure-elasticsearch#config-files-location) using the file backup software of your choice. Snapshots don’t back up these files. Also note that these files will differ on each node, so each node’s files should be backed up individually.
<important>
  The `elasticsearch.keystore`, TLS keys, and [SAML](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/security-settings#ref-saml-settings), [OIDC](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/security-settings#ref-oidc-settings), and [Kerberos](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/security-settings#ref-kerberos-settings) realms private key files contain sensitive information. Consider encrypting your backups of these files.
</important>


## Back up a specific feature state

By default, a snapshot that includes the cluster state also includes all [feature states](/docs/deploy-manage/tools/snapshot-and-restore#feature-state). Similarly, a snapshot that excludes the cluster state excludes all feature states by default.
You can also configure a snapshot to only include specific feature states, regardless of the cluster state.
To get a list of available features, use the [get features API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-features-get-features).
```json
```

The API returns:
```json
{
  "features": [
    {
      "name": "tasks",
      "description": "Manages task results"
    },
    {
      "name": "kibana",
      "description": "Manages Kibana configuration and reports"
    },
    {
      "name": "security",
      "description": "Manages configuration for Security features, such as users and roles"
    },
    ...
  ]
}
```

To include a specific feature state in a snapshot, specify the feature `name` in the `feature_states` array.
For example, the following SLM policy only includes feature states for the Kibana and Elasticsearch security features in its snapshots.
```json

{
  "schedule": "0 30 2 * * ?",
  "name": "<nightly-snap-{now/d}>",
  "repository": "my_repository",
  "config": {
    "indices": "*",
    "include_global_state": true,
    "feature_states": [
      "kibana",
      "security"
    ]
  },
  "retention": {
    "expire_after": "30d",
    "min_count": 5,
    "max_count": 50
  }
}
```

Any index or data stream that’s part of the feature state will display in a snapshot’s contents. For example, if you back up the `security` feature state, the `security-*` system indices display in the [get snapshot API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-snapshot-get)'s response under both `indices` and `feature_states`.

## Dedicated cluster state snapshots

Some feature states contain sensitive data. For example, the `security` feature state includes system indices that may contain user names and encrypted password hashes. Because passwords are stored using [cryptographic hashes](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/security-settings#hashing-settings), the disclosure of a snapshot would not automatically enable a third party to authenticate as one of your users or use API keys. However, it would disclose confidential information, and if a third party can modify snapshots, they could install a back door.
To better protect this data, consider creating a dedicated repository and SLM policy for snapshots of the cluster state. This lets you strictly limit and audit access to the repository.
For example, the following SLM policy only backs up the cluster state. The policy stores these snapshots in a dedicated repository.
```json

{
  "schedule": "0 30 2 * * ?",
  "name": "<nightly-cluster-state-snap-{now/d}>",
  "repository": "my_secure_repository",
  "config": {
    "include_global_state": true,                 <1>
    "indices": "-*"                               <2>
  },
  "retention": {
    "expire_after": "30d",
    "min_count": 5,
    "max_count": 50
  }
}
```

If you take dedicated snapshots of the cluster state, you’ll need to exclude the cluster state from your other snapshots. For example:
```json

{
  "schedule": "0 30 2 * * ?",
  "name": "<nightly-snap-{now/d}>",
  "repository": "my_repository",
  "config": {
    "include_global_state": false,    <1>
    "indices": "*"                    <2>
  },
  "retention": {
    "expire_after": "30d",
    "min_count": 5,
    "max_count": 50
  }
}
```


## Create snapshots at different time intervals

If you only use a single SLM policy, it can be difficult to take frequent snapshots and retain snapshots with longer time intervals.
For example, a policy that takes snapshots every 30 minutes with a maximum of 100 snapshots will only keep snapshots for approximately two days. While this setup is great for backing up recent changes, it doesn’t let you restore data from a previous week or month.
To fix this, you can create multiple SLM policies with the same snapshot repository that run on different schedules. Since a policy’s retention rules only apply to its snapshots, a policy won’t delete a snapshot created by another policy.
For example, the following SLM policy takes hourly snapshots with a maximum of 24 snapshots. The policy keeps its snapshots for one day.
```json

{
  "name": "<hourly-snapshot-{now/d}>",
  "schedule": "0 0 * * * ?",
  "repository": "my_repository",
  "config": {
    "indices": "*",
    "include_global_state": true
  },
  "retention": {
    "expire_after": "1d",
    "min_count": 1,
    "max_count": 24
  }
}
```

The following policy takes nightly snapshots in the same snapshot repository. The policy keeps its snapshots for one month.
```json

{
  "name": "<daily-snapshot-{now/d}>",
  "schedule": "0 45 23 * * ?",          <1>
  "repository": "my_repository",
  "config": {
    "indices": "*",
    "include_global_state": true
  },
  "retention": {
    "expire_after": "30d",
    "min_count": 1,
    "max_count": 31
  }
}
```

The following policy creates monthly snapshots in the same repository. The policy keeps its snapshots for one year.
```json

{
  "name": "<monthly-snapshot-{now/d}>",
  "schedule": "0 56 23 1 * ?",            <1>
  "repository": "my_repository",
  "config": {
    "indices": "*",
    "include_global_state": true
  },
  "retention": {
    "expire_after": "366d",
    "min_count": 1,
    "max_count": 12
  }
}
```