﻿---
title: Manage snapshot repositories in Elastic Cloud Enterprise
description: Snapshots enable you to back up and restore Elasticsearch indices, protecting data from accidental deletion and supporting migration between clusters...
url: https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/cloud-enterprise
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Manage snapshot repositories in Elastic Cloud Enterprise
Snapshots enable you to back up and restore Elasticsearch indices, protecting data from accidental deletion and supporting migration between clusters. In Elastic Cloud Enterprise (ECE), snapshot repositories are managed at the platform level and can be assigned to individual deployments.
When a repository is assigned to a deployment, a snapshot is taken every 30 minutes by default. The snapshot interval can be adjusted per deployment.
<note>
  This section focuses on configuring snapshot repositories at the ECE platform level. These repositories are assigned to deployments and are used by the ECE platform to automatically manage snapshots through the `found-snapshots` repository.In addition to platform-managed repositories, you can also configure snapshot repositories directly at the deployment level. This approach is useful when you need deployment-specific snapshots that are independent of the ECE-managed automation.To register snapshot repositories in ECE directly at the deployment level, follow the guides written for Elastic Cloud Hosted, which are also applicable to ECE deployments:
  - [AWS S3](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/ec-aws-custom-repository)
  - [Azure Blob Storage](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/ec-azure-snapshotting)
  - [Google Cloud Storage](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/ec-gcs-snapshotting)
</note>


## Supported repository types

Elastic Cloud Enterprise installations support the following Elasticsearch snapshot repository types:
- AWS S3
- Azure Blob Storage
- Google Cloud Storage
- MinIO S3

<note>
  No repository types other than those listed are supported in the Elastic Cloud Enterprise platform, even if they are supported by Elasticsearch.
</note>

For more details about how snapshots are used with Elasticsearch, check [Snapshot and Restore](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore). You can also review the official documentation for these storage repository options:
- [Amazon S3 documentation](https://docs.aws.amazon.com/s3/)
- [Microsoft Azure Blob Storage documentation](https://learn.microsoft.com/en-us/azure/storage/blobs/storage-blobs-introduction)
- [Google Cloud Storage documentation](https://cloud.google.com/storage/docs/)

<tip>
  If you are installing ECE without internet access (commonly called an offline or air-gapped installation), you will need to use an on-premise storage service.  We suggest that you use [MinIO](https://www.minio.io/). For our installation notes, check [Snapshotting to MinIO On-Premise Storage](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/minio-on-premise-repository).
</tip>


## Add snapshot repository configurations

The following guides provide instructions on adding a snapshot repository in ECE for all supported types:
- [AWS S3](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/ece-aws-custom-repository)
- [Azure](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/azure-storage-repository)
- [Google Cloud Storage](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/google-cloud-storage-gcs-repository)
- [MinIO](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/minio-on-premise-repository)


## Edit snapshot repository configurations

To edit a snapshot repository configuration from your Elastic Cloud Enterprise installation:
1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
2. From the **Platform** menu, select **Repositories**.
3. Select **Edit** to modify a snapshot repository configuration.
4. Select **Save**.


## Delete snapshot repository configurations

Deleting a snapshot repository configuration does not remove the snapshot repository itself from S3. Only the configuration that enables Elastic Cloud Enterprise to access the repository is removed. Existing snapshots are also retained and need to be deleted separately if you no longer need them.
To delete a snapshot repository configuration from your Elastic Cloud Enterprise installation:
1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
2. From the **Platform** menu, select **Repositories**.
3. Find the repository name that you want to remove.
4. Run the following command against the repository name:
   ```sh
   curl -s -XDELETE -u USER:PASSWORD https://$COORDINATOR_HOST:12443/api/v1/platform/configuration/snapshots/repositories/REPOSITORY_NAME
   ```
   <note>
   The user must have sufficient privileges, such as the `admin` user.
   </note>


## Manage Elasticsearch cluster repositories

You might need to update existing Elasticsearch clusters to use a different snapshot repository for one of the following reasons:
- If you do not want all snapshots for a specific Elasticsearch cluster to go into the same bucket as your other clusters, you can add a new snapshot repository configuration with separate permissions and then change your Elasticsearch cluster to use the new repository.
- If you created an Elasticsearch cluster with no snapshot repository configured, you can add a repository later on. Elastic Cloud Enterprise will start taking snapshots of the cluster automatically.

To change the snapshot repository for an existing Elasticsearch cluster:
1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
2. Optional: If you need to use a repository that is not yet listed, add a snapshot repository configuration first.
3. From the **Deployments** page, select your deployment.
   Narrow the list by name, ID, or choose from several other filters. To further define the list, use a combination of filters.
4. From the **Elasticsearch** menu, select **Snapshots**.
5. Under **Snapshot repository**, choose a different repository and select **Save repository**.

Future snapshots will be sent to the new repository.