﻿---
title: Azure Storage repository
description: This guide focuses on registering an Azure snapshot repository at the Elastic Cloud Enterprise (ECE) platform level. Platform-level repositories can be...
url: https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/azure-storage-repository
products:
  - Elastic Cloud Enterprise
applies_to:
  - Elastic Cloud Enterprise: Generally available
---

# Azure Storage repository
This guide focuses on registering an Azure snapshot repository at the Elastic Cloud Enterprise (ECE) platform level. Platform-level repositories can be assigned to deployments and are used by ECE to automatically manage snapshots through the `found-snapshots` repository.
If you have custom requirements or deployment-specific use cases that are independent of the ECE-managed automation, you can also register snapshot repositories directly at the deployment level. To do that, follow the [Elastic Cloud Hosted guide for Azure Blob Storage](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/ec-azure-snapshotting), which is also applicable to Elastic Cloud Enterprise deployments.
At the ECE platform level, you can enable your Elasticsearch clusters to regularly snapshot data to Microsoft Azure Storage.

## Add the Azure repository

Add your Azure Storage Container as a repository to the platform:
1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
2. Go to **Platform > Repositories** and add the following snapshot repository configuration under the advanced mode:
   If needed, set additional options for configuring chunk_size, compressions, and retries. Check the [supported settings](/docs/deploy-manage/tools/snapshot-and-restore/azure-repository#repository-azure-repository-settings).
   ```json
   {
     "type": "azure",
     "settings": {
       "account": "AZURE STORAGE ACCOUNT NAME",
       "sas_token": "AZURE SAS_TOKEN",
       "container": "BACKUP-CONTAINER"
     }
   }
   ```
3. Select **Save**.


## Configure your deployment to use the repository

After adding the snapshots repository, [configure your deployment to use it](/docs/deploy-manage/tools/snapshot-and-restore/cloud-enterprise#ece-manage-repositories-clusters). Once configured, snapshots run automatically according to the scheduled interval. You can update this schedule from the **Snapshots** section in the **Elasticsearch** menu of your deployment page.