﻿---
title: Snapshot and restore
description: A snapshot is a backup of a running Elasticsearch cluster. You can use snapshots to: Regularly back up a cluster with no downtime, Recover data after...
url: https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore
products:
  - Elastic Cloud Enterprise
  - Elastic Cloud Hosted
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Snapshot and restore
A snapshot is a backup of a running Elasticsearch cluster. You can use snapshots to:
- Regularly back up a cluster with no downtime
- Recover data after deletion or a hardware failure
- Transfer data between clusters
- Reduce storage costs by using **[searchable snapshots](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/searchable-snapshots)** in the cold and frozen data tiers

<important>
  Snapshots preserve more than your data. They also include the configuration and internal data of Elastic Stack features, such as ILM policies, index templates and pipelines, Kibana saved objects, alerting rules, Fleet settings and integrations, Elastic Security data, and more, depending on your use case.Consider using snapshots to back up, at minimum, all Elasticsearch system indices and the cluster state, even if your data can be reindexed or recovered from other external sources. Without these backups, a disaster recovery scenario can result in the loss of your stack configuration and feature states, even if the underlying data can be restored.
</important>


## Snapshot workflow

Elasticsearch stores snapshots in an off-cluster storage location called a **snapshot repository**. Before you can take or restore snapshots, you must [register a snapshot repository](/docs/deploy-manage/tools/snapshot-and-restore/self-managed#manage-snapshot-repos) on the cluster. Elasticsearch supports different repository types depending on your deployment type:
- [**Elastic Cloud Hosted repository types**](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/elastic-cloud-hosted)
- [**Self-managed repository types**](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/self-managed)

After you register a snapshot repository, you can use [snapshot lifecycle management (SLM)](/docs/deploy-manage/tools/snapshot-and-restore/create-snapshots#automate-snapshots-slm) to automatically take and manage snapshots. You can then [restore a snapshot](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/restore-snapshot) to recover or transfer its data.
<note>
  While the majority of snapshot-related operations are similar across all deployment types, Elastic Cloud Hosted, Elastic Cloud Enterprise (ECE), and Elastic Cloud on Kubernetes (ECK) offer additional capabilities, as described below.
</note>

<dropdown title="Elastic Cloud Hosted">
  When you create a deployment, a default repository called `found-snapshots` is automatically added to the Elasticsearch cluster. This repository is specific to that cluster: the `cluster ID` is part of the repository’s `base_path`, such as `/snapshots/[cluster-id]`.
  <note>
    Do not disable or delete the default `cloud-snapshot-policy` SLM policy, and do not change the default `found-snapshots` repository defined in that policy. These actions are not supported.
  </note>
  The default policy and repository are used when:
  - Creating a new deployment from a snapshot
  - Restoring a snapshot to a different deployment
  - Taking automated snapshots in case of deployment changes
  In Elastic Cloud Hosted, you can [restore snapshots](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/restore-snapshot) across clusters, but only within the same region.You can customize the snapshot retention settings in that policy to adjust them to your needs.To use a custom snapshot repository, [register a new snapshot repository](/docs/deploy-manage/tools/snapshot-and-restore/self-managed#manage-snapshot-repos) and [create another SLM policy](/docs/deploy-manage/tools/snapshot-and-restore/create-snapshots#automate-snapshots-slm).
</dropdown>

<dropdown title="Elastic Cloud Enterprise">
  To enable snapshots for your Elasticsearch clusters, you must first [configure a repository](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/cloud-enterprise) at the platform level in ECE and then associate it with your deployments. Once configured, snapshots are taken every 30 minutes or at the interval you specify.Use **Kibana** to manage your snapshots. In Kibana, you can:
  - Set up additional repositories where snapshots are stored (other than the one managed by Elastic Cloud Enterprise)
  - View and delete snapshots
  - Configure a snapshot lifecycle management (SLM) policy to automate when snapshots are created and deleted
  In **Elastic Cloud Enterprise**, you can also [restore snapshots](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/restore-snapshot) across clusters.
</dropdown>

<dropdown title="Elastic Cloud on Kubernetes (ECK)">
  On Elastic Cloud on Kubernetes, you must manually configure snapshot repositories. The system does not create **Snapshot Lifecycle Management (SLM) policies** or **automatic snapshots** by default.For detailed configuration steps, refer to [Configuring snapshots on ECK](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/cloud-on-k8s).
</dropdown>

<note>
  Snapshots back up only open indices. If you close an index, it is not included in snapshots and you will not be able to restore the data.
</note>


## Snapshot contents

By default, a snapshot of a cluster contains the cluster state, all regular data streams, and all regular indices. The cluster state includes:
- [Persistent cluster settings](/docs/deploy-manage/deploy/self-managed/configure-elasticsearch#cluster-setting-types)
- [Index templates](https://www.elastic.co/docs/manage-data/data-store/templates)
- [Legacy index templates](https://www.elastic.co/guide/en/elasticsearch/reference/8.18/indices-templates-v1.html)
- [Ingest pipelines](https://www.elastic.co/docs/manage-data/ingest/transform-enrich/ingest-pipelines)
- [ILM policies](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management)
- [Stored scripts](https://www.elastic.co/docs/explore-analyze/scripting/modules-scripting-store-and-retrieve)
- For snapshots taken after 7.12.0, [feature states](#feature-state)

You can also take snapshots of only specific data streams or indices in the cluster. A snapshot that includes a data stream or index automatically includes its aliases. When you restore a snapshot, you can choose whether to restore these aliases.
Snapshots don’t contain or back up:
- Transient cluster settings
- Registered snapshot repositories
- Node configuration files
- [Security configuration files](https://www.elastic.co/docs/deploy-manage/security)


### Feature states

A feature state contains the indices and data streams used to store configurations, history, and other data for an Elastic feature, such as Elasticsearch security, Kibana, Fleet, or Watcher. To retrieve a list of feature states, use the [Features API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-features-get-features).
```json
```

A feature state typically includes one or more [system indices or system data streams](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/api-conventions#system-indices). It may also include regular indices and data streams used by the feature. For example, a feature state may include a regular index that contains the feature’s execution history. Storing this history in a regular index lets you more easily search it.
Starting with Elasticsearch 8.0 and later versions, feature states are the only way to back up and restore system indices and system data streams. Attempting to restore a system index or data stream outside its feature state is not permitted and will result in the following error:
```
requested system indices [.example], but system indices can only be restored as part of a feature state
```

Restoring system indices and data streams will require temporary elevated permissions to edit restricted indices. For more information, refer to [File-based access recovery](https://www.elastic.co/docs/troubleshoot/elasticsearch/file-based-recovery). Attempting to restore a system index or data stream without the required temporary elevated permissions will result in the following error:
```
Indices [.example] use and access is reserved for system operations
```


## How snapshots work

Snapshots are **automatically deduplicated** to save storage space and reduce network transfer costs. To back up an index, a snapshot makes a copy of the index’s [segments](https://www.elastic.co/docs/manage-data/data-store/near-real-time-search) and stores them in the snapshot repository. Since segments are immutable, the snapshot only needs to copy any new segments created since the repository’s last snapshot.
Each snapshot is **logically independent**. When you delete a snapshot, Elasticsearch only deletes the segments used exclusively by that snapshot. Elasticsearch doesn’t delete segments used by other snapshots in the repository.

### Snapshots and shard allocation

A snapshot copies segments from an index’s primary shards. When you start a snapshot, Elasticsearch immediately starts copying the segments of any available primary shards. If a shard is starting or relocating, Elasticsearch will wait for these processes to complete before copying the shard’s segments. If one or more primary shards aren’t available, the snapshot attempt fails.
Once a snapshot begins copying a shard’s segments, Elasticsearch won’t move the shard to another node, even if rebalancing or shard allocation settings would typically trigger reallocation. Elasticsearch will only move the shard after the snapshot finishes copying the shard’s data.

### Snapshot start and stop times

A snapshot doesn’t represent a cluster at a precise point in time. Instead, each snapshot includes a start and end time. The snapshot represents a view of each shard’s data at some point between these two times.

## Snapshot compatibility

To restore a snapshot to a cluster, the versions for the snapshot, cluster, and any restored indices must be compatible.

### Snapshot version compatibility

You can’t restore a snapshot to an earlier version of Elasticsearch. For example, you can’t restore a snapshot taken in 7.6.0 to a cluster running 7.5.0.

### Index compatibility

Any index you restore from a snapshot must also be compatible with the current cluster’s version. If you try to restore an index created in an incompatible version, the restore attempt fails.

| Index creation version | 9.0.0–9.3.0 | 8.3–8.19 | 8.0–8.2 | 7.2–7.17 | 7.0–7.1 | 6.8 |
|------------------------|-------------|----------|---------|----------|---------|-----|
| 5.0–5.6                | ✅ ^1^       | ✅ ^1^    | ❌       | ❌        | ❌       | ✅   |
| 6.0–6.7                | ✅ ^1^       | ✅ ^1^    | ❌       | ✅        | ✅       | ✅   |
| 6.8                    | ✅ ^1^       | ✅ ^1^    | ❌       | ✅        | ❌       | ✅   |
| 7.0–7.1                | ✅ ^1, 2^    | ✅        | ✅       | ✅        | ✅       | ❌   |
| 7.2–7.17               | ✅ ^1, 2^    | ✅        | ✅       | ✅        | ❌       | ❌   |
| 8.0–8.19               | ✅           | ✅        | ✅       | ❌        | ❌       | ❌   |
| 9.0.0–9.3.0            | ✅           | ❌        | ❌       | ❌        | ❌       | ❌   |

^1^  Supported with [archive indices](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/reading-indices-from-older-elasticsearch-versions).
^2^  Supported with [searchable snapshots](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/searchable-snapshots).
You can’t restore an index to an earlier version of Elasticsearch. For example, you can’t restore an index created in 8.18.0 to a cluster running 8.15.0.

#### Restoring incompatible indices

A compatible snapshot can contain indices created in an older incompatible version. To restore these incompatible indices, you must take additional steps. For example, a snapshot of a 7.17 cluster might contain an index created in 6.8. Restoring the 6.8 index to an 8.18 cluster fails unless you use the [archive functionality](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/reading-indices-from-older-elasticsearch-versions). To restore a 7.17 index to a 9.0 cluster, you can use the [archive functionality](https://www.elastic.co/docs/deploy-manage/upgrade/deployment-or-cluster/reading-indices-from-older-elasticsearch-versions) or [searchable snapshots](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/searchable-snapshots). Keep this in mind if you take a snapshot before upgrading a cluster.
To ensure index compatibility, you can first restore the index to another cluster running the latest version of Elasticsearch that’s compatible with both the index and your current cluster. You can then use [reindex-from-remote](https://www.elastic.co/guide/en/elasticsearch/reference/8.18/docs-reindex.html#reindex-from-remote) to rebuild the index on your current cluster. Reindex from remote is only possible if the index’s [`_source`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-source-field) is enabled.
Reindexing from remote can take significantly longer than restoring a snapshot. Before you start, test the reindex from remote process with a subset of the data to estimate your time requirements.

## Warnings


### Other backup methods

**Taking a snapshot is the only reliable and supported way to back up a cluster.** You cannot back up an Elasticsearch cluster by making copies of the data directories of its nodes. There are no supported methods to restore any data from a filesystem-level backup. If you try to restore a cluster from such a backup, it may fail with reports of corruption or missing files or other data inconsistencies, or it may appear to have succeeded having silently lost some of your data.
A copy of the data directories of a cluster’s nodes does not work as a backup because it is not a consistent representation of their contents at a single point in time. You cannot fix this by shutting down nodes while making the copies, nor by taking atomic filesystem-level snapshots, because Elasticsearch has consistency requirements that span the whole cluster. You must use the built-in snapshot functionality for cluster backups.

### Repository contents

**Don’t modify anything within the repository or run processes that might interfere with its contents.** If something other than Elasticsearch modifies the contents of the repository then future snapshot or restore operations may fail, reporting corruption or other data inconsistencies, or may appear to succeed having silently lost some of your data.
You may however safely [restore a repository from a backup](/docs/deploy-manage/tools/snapshot-and-restore/self-managed#snapshots-repository-backup) as long as
1. The repository is not registered with Elasticsearch while you are restoring its contents.
2. When you have finished restoring the repository its contents are exactly as they were when you took the backup.

If you no longer need any of the snapshots in a repository, unregister it from Elasticsearch before deleting its contents from the underlying storage.
Additionally, snapshots may contain security-sensitive information, which you may wish to [store in a dedicated repository](/docs/deploy-manage/tools/snapshot-and-restore/create-snapshots#cluster-state-snapshots).