﻿---
title: Upgrading clusters
description: Clusters that are actively using cross-cluster replication require a careful approach to upgrades. The following conditions could cause index following...
url: https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication/upgrading-clusters
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Upgrading clusters
Clusters that are actively using cross-cluster replication require a careful approach to upgrades. The following conditions could cause index following to fail during rolling upgrades:
- Clusters that have not yet been upgraded will reject new index settings or mapping types that are replicated from an upgraded cluster.
- Nodes in a cluster that has not been upgraded will reject index files from a node in an upgraded cluster when index following tries to fall back to file-based recovery. This limitation is due to Lucene not being forward compatible.

The approach to running a rolling upgrade on clusters where cross-cluster replication is enabled differs based on uni-directional and bi-directional index following.