﻿---
title: Uni-directional disaster recovery
description: Learn how to failover and failback between two clusters based on uni-directional cross-cluster replication. You can also visit Bi-directional disaster...
url: https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication/uni-directional-disaster-recovery
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Uni-directional disaster recovery
Learn how to failover and failback between two clusters based on uni-directional cross-cluster replication. You can also visit [Bi-directional disaster recovery](https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication/bi-directional-disaster-recovery) to set up replicating data streams that automatically failover and failback without human intervention.
- Setting up uni-directional cross-cluster replication replicated from `clusterA` to `clusterB`.
- Failover - If `clusterA` goes offline, `clusterB` needs to "promote" follower indices to regular indices to allow write operations. All ingestion will need to be redirected to `clusterB`, this is controlled by the clients (Logstash, Beats, Elastic Agents, etc).
- Failback - When `clusterA` is back online, it assumes the role of a follower and replicates the leader indices from `clusterB`.

![Uni-directional cross cluster replication failover and failback](https://www.elastic.co/docs/deploy-manage/images/elasticsearch-reference-ccr-uni-directional-disaster-recovery.png)

<note>
  Cross-cluster replication provides functionality to replicate user-generated indices only. Cross-cluster replication isn’t designed for replicating system-generated indices or snapshot settings, and can’t replicate ILM or SLM policies across clusters. Learn more in cross-cluster replication [limitations](/docs/deploy-manage/tools/cross-cluster-replication#ccr-limitations).
</note>