﻿---
title: Set up cross-cluster replication
description: Use this guide to set up cross-cluster replication (CCR) between clusters in two datacenters. Replicating your data across datacenters provides several...
url: https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication/set-up-cross-cluster-replication
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Set up cross-cluster replication
Use this guide to set up cross-cluster replication (CCR) between clusters in two datacenters. Replicating your data across datacenters provides several benefits:
- Brings data closer to your users or application server to reduce latency and response time
- Provides your mission-critical applications with the tolerance to withstand datacenter or region outages

In this guide, you’ll learn how to:
- Configure a [remote cluster](https://www.elastic.co/docs/deploy-manage/remote-clusters) with a leader index
- Create a follower index on a local cluster
- Create an auto-follow pattern to automatically follow time series indices that are periodically created in a remote cluster

You can manually create follower indices to replicate specific indices on a remote cluster, or configure auto-follow patterns to replicate rolling time series indices.
<tip>
  If you want to replicate data across clusters in the cloud, you can [configure remote clusters on Elastic Cloud](https://www.elastic.co/docs/deploy-manage/remote-clusters/ec-enable-ccs). Then, you can [search across clusters](https://www.elastic.co/docs/explore-analyze/cross-cluster-search) and set up cross-cluster replication.
</tip>