﻿---
title: Manage auto-follow patterns
description: To replicate time series indices, you configure an auto-follow pattern so that each new index in the series is replicated automatically. Whenever the...
url: https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication/manage-auto-follow-patterns
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Manage auto-follow patterns
To replicate time series indices, you configure an auto-follow pattern so that each new index in the series is replicated automatically. Whenever the name of a new index on the remote cluster matches the auto-follow pattern, a corresponding follower index is added to the local cluster.
<note>
  Auto-follow patterns only match open indices on the remote cluster that have all primary shards started. Auto-follow patterns do not match indices that can’t be used for CCR such as [closed indices](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-open) or [searchable snapshots](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/searchable-snapshots). Avoid using an auto-follow pattern that matches indices with a [read or write block](https://www.elastic.co/docs/reference/elasticsearch/index-settings/index-block). These blocks prevent follower indices from replicating such indices.
</note>

You can also create auto-follow patterns for data streams. When a new backing index is generated on a remote cluster, that index and its data stream are automatically followed if the data stream name matches an auto-follow pattern. If you create a data stream after creating the auto-follow pattern, all backing indices are followed automatically.
The data streams replicated from a remote cluster by CCR are protected from local rollovers. The [promote data stream API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-promote-data-stream) can be used to turn these data streams into regular data streams.
Auto-follow patterns are especially useful with [Index lifecycle management](https://www.elastic.co/docs/manage-data/lifecycle/index-lifecycle-management), which might continually create new indices on the cluster containing the leader index.

To start using cross-cluster replication auto-follow patterns from Kibana:
1. Go to the **Cross Cluster Replication** management page in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Choose the **Follower Indices** tab.