﻿---
title: Uni-directional index following
description: In a uni-directional configuration, one cluster contains only leader indices, and the other cluster contains only follower indices that replicate the...
url: https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication/ccr-uni-directional-upgrade
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Uni-directional index following
In a uni-directional configuration, one cluster contains only leader indices, and the other cluster contains only follower indices that replicate the leader indices.
In this strategy, the cluster with follower indices should be upgraded first and the cluster with leader indices should be upgraded last. Upgrading the clusters in this order ensures that index following can continue during the upgrade without downtime.
You can also use this strategy to upgrade a [replication chain](/docs/deploy-manage/tools/cross-cluster-replication#ccr-chained-replication). Start by upgrading clusters at the end of the chain and working your way back to the cluster that contains the leader indices.
For example, consider a configuration where Cluster A contains all leader indices. Cluster B follows indices in Cluster A, and Cluster C follows indices in Cluster B.
```
Cluster A
        ^--Cluster B
                   ^--Cluster C
```

In this configuration, upgrade the clusters in the following order:
1. Cluster C
2. Cluster B
3. Cluster A