﻿---
title: Recreate a follower index
description: When a document is updated or deleted, the underlying operation is retained in the Lucene index for a period of time defined by the index.soft_deletes.retention_lease.period...
url: https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication/ccr-recreate-follower-index
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Recreate a follower index
When a document is updated or deleted, the underlying operation is retained in the Lucene index for a period of time defined by the [`index.soft_deletes.retention_lease.period`](https://www.elastic.co/docs/reference/elasticsearch/index-settings/index-modules#ccr-index-soft-deletes-retention-period) parameter. You configure this setting on the [leader index](/docs/deploy-manage/tools/cross-cluster-replication#ccr-leader-requirements).
When a follower index starts, it acquires a retention lease from the leader index. This lease informs the leader that it should not allow a soft delete to be pruned until either the follower indicates that it has received the operation, or until the lease expires.
If a follower index falls sufficiently behind a leader and cannot replicate operations, Elasticsearch reports an `indices[].fatal_exception` error. To resolve the issue, recreate the follower index. When the new follow index starts, the [remote recovery](/docs/deploy-manage/tools/cross-cluster-replication#ccr-remote-recovery) process recopies the Lucene segment files from the leader.
<important>
  Recreating the follower index is a destructive action. All existing Lucene segment files are deleted on the cluster containing the follower index.
</important>

To recreate a follower index, [access Cross-Cluster Replication](/docs/deploy-manage/tools/cross-cluster-replication/manage-cross-cluster-replication#ccr-access-ccr) and choose the **Follower indices** tab.
Select the follower index and pause replication. When the follower index status changes to Paused, reselect the follower index and choose to unfollow the leader index.
The follower index will be converted to a standard index and will no longer display on the Cross-Cluster Replication page.
In the side navigation, choose **Index Management**. Select the follower index from the previous steps and close the follower index.
You can then [recreate the follower index](https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication/ccr-getting-started-follower-index) to restart the replication process.
<dropdown title="Use the API">
  Use the [pause follow API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ccr-pause-follow) to pause the replication process. Then, close the follower index and recreate it. For example:
  ```json





  {
    "remote_cluster" : "remote_cluster",
    "leader_index" : "leader_index"
  }
  ```
</dropdown>