﻿---
title: Prerequisites for cross-cluster replication
description: To complete this tutorial, you need: The manage cluster privilege on the local cluster.Both clusters must have the same license type, and that license...
url: https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication/ccr-getting-started-prerequisites
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Prerequisites for cross-cluster replication
To complete this tutorial, you need:
- The `manage` cluster privilege on the local cluster.
- Both clusters must have the same [license](https://www.elastic.co/docs/deploy-manage/license) type, and that license must support cross-cluster replication.
  - [Activate a free 30-day trial](https://www.elastic.co/docs/deploy-manage/license/manage-your-license-in-self-managed-cluster).
- An index on the remote cluster that contains the data you want to replicate. This tutorial uses the sample eCommerce orders data set. [Load sample data](/docs/explore-analyze#gs-get-data-into-kibana).
- In the local cluster, all nodes with the `master` [node role](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/node-settings#node-roles) must also have the [`remote_cluster_client`](/docs/deploy-manage/distributed-architecture/clusters-nodes-shards/node-roles#remote-node) role. The local cluster must also have at least one node with both a data role and the [`remote_cluster_client`](/docs/deploy-manage/distributed-architecture/clusters-nodes-shards/node-roles#remote-node) role. Individual tasks for coordinating replication scale based on the number of data nodes with the `remote_cluster_client` role in the local cluster.