﻿---
title: Create an auto-follow pattern to replicate time series indices
description: You use auto-follow patterns to automatically create new followers for rolling time series indices. Whenever the name of a new index on the remote cluster...
url: https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication/ccr-getting-started-auto-follow
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Create an auto-follow pattern to replicate time series indices
You use [auto-follow patterns](https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication/manage-auto-follow-patterns) to automatically create new followers for rolling time series indices. Whenever the name of a new index on the remote cluster matches the auto-follow pattern, a corresponding follower index is added to the local cluster. Note that only indices created on the remote cluster after the auto-follow pattern is created will be auto-followed: existing indices on the remote cluster are ignored even if they match the pattern.
An auto-follow pattern specifies the remote cluster you want to replicate from, and one or more index patterns that specify the rolling time series indices you want to replicate.
To create an auto-follow pattern from in Kibana:
1. Go to the **Cross Cluster Replication** management page in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Choose the **Auto-follow patterns** tab.
3. Enter a name for the auto-follow pattern, such as `beats`.
4. Choose the remote cluster that contains the index you want to replicate, which in the example scenario is Cluster A.
5. Enter one or more index patterns that identify the indices you want to replicate from the remote cluster. For example, enter `metricbeat-* packetbeat-*` to automatically create followers for Metricbeat and Packetbeat indices.
6. Enter **follower-** as the prefix to apply to the names of the follower indices so you can more easily identify replicated indices.

As new indices matching these patterns are created on the remote, Elasticsearch automatically replicates them to local follower indices.
![The Auto-follow patterns page in Kibana](https://www.elastic.co/docs/deploy-manage/images/elasticsearch-reference-auto-follow-patterns.png)

<dropdown title="API example">
  Use the [create auto-follow pattern API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ccr-put-auto-follow-pattern) to configure auto-follow patterns.
  ```json

  {
    "remote_cluster" : "leader",
    "leader_index_patterns" :
    [
      "metricbeat-*", <1>
      "packetbeat-*" <2>
    ],
    "follow_index_pattern" : "{{leader_index}}-copy" <3>
  }
  ```
</dropdown>