﻿---
title: Bi-directional disaster recovery
description: Learn how to set up disaster recovery between two clusters based on bi-directional cross-cluster replication. The following tutorial is designed for data...
url: https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication/bi-directional-disaster-recovery
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Bi-directional disaster recovery
Learn how to set up disaster recovery between two clusters based on bi-directional cross-cluster replication. The following tutorial is designed for data streams which support [update by query](/docs/manage-data/data-store/data-streams/use-data-stream#update-docs-in-a-data-stream-by-query) and [delete by query](/docs/manage-data/data-store/data-streams/use-data-stream#delete-docs-in-a-data-stream-by-query). You can only perform these actions on the leader index.
This tutorial works with Logstash as the source of ingestion. It takes advantage of a Logstash feature where [the Logstash output to Elasticsearch](https://www.elastic.co/docs/reference/logstash/plugins/plugins-outputs-elasticsearch) can be load balanced across an array of hosts specified. Beats and Elastic Agents currently do not support multiple outputs. It should also be possible to set up a proxy (load balancer) to redirect traffic without Logstash in this tutorial.
- Setting up a remote cluster on `clusterA` and `clusterB`.
- Setting up bi-directional cross-cluster replication with exclusion patterns.
- Setting up Logstash with multiple hosts to allow automatic load balancing and switching during disasters.

![Bi-directional cross cluster replication failover and failback](https://www.elastic.co/docs/deploy-manage/images/elasticsearch-reference-ccr-bi-directional-disaster-recovery.png)