﻿---
title: Prerequisites for uni-directional disaster recovery
description: Before completing this tutorial, set up cross-cluster replication to connect two clusters and configure a follower index. In this tutorial, kibana_sample_data_ecommerce...
url: https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication/_prerequisites_14
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Prerequisites for uni-directional disaster recovery
Before completing this tutorial, [set up cross-cluster replication](https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication/set-up-cross-cluster-replication) to connect two clusters and configure a follower index.
In this tutorial, `kibana_sample_data_ecommerce` is replicated from `clusterA` to `clusterB`.
```json
## On clusterB ###

{
  "persistent": {
    "cluster": {
      "remote": {
        "clusterA": {
          "mode": "proxy",
          "skip_unavailable": "true",
          "server_name": "clustera.es.region-a.gcp.elastic-cloud.com",
          "proxy_socket_connections": "18",
          "proxy_address": "clustera.es.region-a.gcp.elastic-cloud.com:9400"
        }
      }
    }
  }
}
```

```json
## On clusterB ###

{
  "remote_cluster": "clusterA",
  "leader_index": "kibana_sample_data_ecommerce"
}
```

<important>
  Writes (such as ingestion or updates) should occur only on the leader index. Follower indices are read-only and will reject any writes.
</important>