﻿---
title: Perform update or delete by query
description: It is possible to update or delete the documents but you can only perform these actions on the leader index. First identify which backing index contains...
url: https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication/_perform_update_or_delete_by_query
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Perform update or delete by query
It is possible to update or delete the documents but you can only perform these actions on the leader index.
1. First identify which backing index contains the document you want to update.
   ```json
   ### On either of the cluster ###

   {
   "query": {
       "match": {
         "event.sequence": "97"
       }
     }
   }
   ```
   - If the hits returns `"_index": ".ds-logs-generic-default-replicated_from_clustera-<yyyy.MM.dd>-*"`, then you need to proceed to the next step on `cluster A`.
- If the hits returns `"_index": ".ds-logs-generic-default-replicated_from_clusterb-<yyyy.MM.dd>-*"`, then you need to proceed to the next step on `cluster B`.
- If the hits returns `"_index": ".ds-logs-generic-default-<yyyy.MM.dd>-*"`, then you need to proceed to the next step on the same cluster where you performed the search query.
2. Perform the update (or delete) by query:
   ```json
   ### On the cluster identified from the previous step ###

   {
     "query": {
       "match": {
         "event.sequence": "97"
       }
     },
     "script": {
       "source": "ctx._source.event.original = params.new_event",
       "lang": "painless",
       "params": {
         "new_event": "FOOBAR"
       }
     }
   }
   ```
   <tip>
   If a soft delete is merged away before it can be replicated to a follower the following process will fail due to incomplete history on the leader, see [index.soft_deletes.retention_lease.period](https://www.elastic.co/docs/reference/elasticsearch/index-settings/index-modules#ccr-index-soft-deletes-retention-period) for more details.
   </tip>