﻿---
title: Bi-directional recovery: Failover when clusterA is down
description: You can simulate this by shutting down either of the clusters. Let’s shut down cluster A in this tutorial.Start Logstash with the same configuration file...
url: https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication/_failover_when_clustera_is_down_2
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Bi-directional recovery: Failover when clusterA is down
1. You can simulate this by shutting down either of the clusters. Let’s shut down `cluster A` in this tutorial.
2. Start Logstash with the same configuration file. (This step is not required in real use cases where Logstash ingests continuously.)
   ```sh
   ### On Logstash server ###
   bin/logstash -f multiple_hosts.conf
   ```
3. Observe all Logstash traffic will be redirected to `cluster B` automatically.
   <tip>
   You should also redirect all search traffic to the `clusterB` cluster during this time.
   </tip>
4. The two data streams on `cluster B` now contain a different number of documents.
   - data streams on cluster A (down)
  - 50 documents in `logs-generic-default-replicated_from_clusterb`
- 50 documents in `logs-generic-default`
- data streams On cluster B (up)
  - 50 documents in `logs-generic-default-replicated_from_clustera`
- 150 documents in `logs-generic-default`