﻿---
title: Uni-directional recovery: failover when clusterA is down
description: Promote the follower indices in clusterB into regular indices so that they accept writes. This can be achieved by:, On the client side (Logstash, Beats,...
url: https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication/_failover_when_clustera_is_down
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Uni-directional recovery: failover when clusterA is down
1. Promote the follower indices in `clusterB` into regular indices so that they accept writes. This can be achieved by:
   - First, pause indexing following for the follower index.
- Next, close the follower index.
- Unfollow the leader index.
- Finally, open the follower index (which at this point is a regular index).
   ```json
   ### On clusterB ###
   ```
2. On the client side (Logstash, Beats, Elastic Agent), manually re-enable ingestion of `kibana_sample_data_ecommerce2` and redirect traffic to the `clusterB`. You should also redirect all search traffic to the `clusterB` cluster during this time. You can simulate this by ingesting documents into this index. You should notice this index is now writable.
   ```json
   ### On clusterB ###

   {
     "user": "kimchy"
   }
   ```