﻿---
title: Uni-directional recovery: failback when clusterA comes back
description: When clusterA comes back, clusterB becomes the new leader and clusterA becomes the follower. Set up remote cluster clusterB on clusterA.Existing data...
url: https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication/_failback_when_clustera_comes_back
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Uni-directional recovery: failback when clusterA comes back
When `clusterA` comes back, `clusterB` becomes the new leader and `clusterA` becomes the follower.
1. Set up remote cluster `clusterB` on `clusterA`.
   ```json
   ### On clusterA ###

   {
     "persistent": {
       "cluster": {
         "remote": {
           "clusterB": {
             "mode": "proxy",
             "skip_unavailable": "true",
             "server_name": "clusterb.es.region-b.gcp.elastic-cloud.com",
             "proxy_socket_connections": "18",
             "proxy_address": "clusterb.es.region-b.gcp.elastic-cloud.com:9400"
           }
         }
       }
     }
   }
   ```
2. Existing data needs to be discarded before you can turn any index into a follower. Ensure the most up-to-date data is available on `clusterB` prior to deleting any indices on `clusterA`.
   ```json
   ### On clusterA ###
   ```
3. Create a follower index on `clusterA`, now following the leader index in `clusterB`.
   ```json
   ### On clusterA ###

   {
     "remote_cluster": "clusterB",
     "leader_index": "kibana_sample_data_ecommerce2"
   }
   ```
4. The index on the follower cluster now contains the updated documents.
   ```json
   ### On clusterA ###
   ```
   <tip>
   If a soft delete is merged away before it can be replicated to a follower the following process will fail due to incomplete history on the leader, see [index.soft_deletes.retention_lease.period](https://www.elastic.co/docs/reference/elasticsearch/index-settings/index-modules#ccr-index-soft-deletes-retention-period) for more details.
   </tip>