﻿---
title: Connect to a remote cluster
description: Cross-cluster replication (CCR) relies on the remote clusters feature. Before configuring CCR, ensure that the source cluster (Cluster A) is registered...
url: https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication/_connect_to_a_remote_cluster
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Connect to a remote cluster
Cross-cluster replication (CCR) relies on the [remote clusters](https://www.elastic.co/docs/deploy-manage/remote-clusters) feature. Before configuring CCR, ensure that the source cluster (Cluster A) is registered as a remote cluster on the destination cluster (Cluster B).
![ClusterA contains the leader index and ClusterB contains the follower index](https://www.elastic.co/docs/deploy-manage/images/elasticsearch-reference-ccr-tutorial-clusters.png)

<admonition title="Note about terminology">
  In the case of remote clusters, the Elasticsearch cluster or deployment initiating the connection and requests is often referred to as the **local cluster**, while the Elasticsearch cluster or deployment receiving the requests is referred to as the **remote cluster**.
</admonition>

Connecting to a remote cluster depends on the environment your local and remote clusters are deployed on and the security model you wish to use.
The exact details needed to connect to a remote cluster vary. Select a suitable option for your specific scenario based on the local cluster you're configuring:
- [Remote clusters on self-managed installations](https://www.elastic.co/docs/deploy-manage/remote-clusters/remote-clusters-self-managed)
- [Remote clusters on Elastic Cloud Hosted](https://www.elastic.co/docs/deploy-manage/remote-clusters/ec-enable-ccs)
- [Remote clusters on Elastic Cloud Enterprise](https://www.elastic.co/docs/deploy-manage/remote-clusters/ece-enable-ccs)
- [Remote clusters on Elastic Cloud on Kubernetes](https://www.elastic.co/docs/deploy-manage/remote-clusters/eck-remote-clusters-landing)