﻿---
title: Configure privileges for cross-cluster replication
description: The cross-cluster replication user requires different cluster and index privileges on the remote cluster and local cluster. Use the following requests...
url: https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication/_configure_privileges_for_cross_cluster_replication_2
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Configure privileges for cross-cluster replication
The cross-cluster replication user requires different cluster and index privileges on the remote cluster and local cluster. Use the following requests to create separate roles on the local and remote clusters, and then create a user with the required roles.

## Remote cluster

On the remote cluster that contains the leader index, the cross-cluster replication role requires the `read_ccr` cluster privilege, and `monitor` and `read` privileges on the leader index.
<note>
  If requests are authenticated with an [API key](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-create-api-key), the API key requires the above privileges on the **local** cluster, instead of the remote.
</note>

<note>
  If requests are issued [on behalf of other users](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/submitting-requests-on-behalf-of-other-users), then the authenticating user must have the `run_as` privilege on the remote cluster.
</note>

The following request creates a `remote-replication` role on the remote cluster:
```json

{
  "cluster": [
    "read_ccr"
  ],
  "indices": [
    {
      "names": [
        "leader-index-name"
      ],
      "privileges": [
        "monitor",
        "read"
      ]
    }
  ]
}
```


## Local cluster

On the local cluster that contains the follower index, the `remote-replication` role requires the `manage_ccr` cluster privilege, and `monitor`, `read`, `write`, and `manage_follow_index` privileges on the follower index.
The following request creates a `remote-replication` role on the local cluster:
```json

{
  "cluster": [
    "manage_ccr"
  ],
  "indices": [
    {
      "names": [
        "follower-index-name"
      ],
      "privileges": [
        "monitor",
        "read",
        "write",
        "manage_follow_index"
      ]
    }
  ]
}
```

After creating the `remote-replication` role on each cluster, use the [create or update users API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-put-user) to create a user on the local cluster cluster and assign the `remote-replication` role. For example, the following request assigns the `remote-replication` role to a user named `cross-cluster-user`:
```json

{
  "password" : "l0ng-r4nd0m-p@ssw0rd",
  "roles" : [ "remote-replication" ]
}
```

<note>
  You only need to create this user on the **local** cluster.
</note>