﻿---
title: Backup, high availability, and resilience tools
description: Elastic provides comprehensive tools to safeguard data, ensure continuous availability, and maintain resilience. These tools are designed to support disaster...
url: https://www.elastic.co/docs/deploy-manage/tools
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud on Kubernetes: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Backup, high availability, and resilience tools
Elastic provides comprehensive tools to safeguard data, ensure continuous availability, and maintain resilience. These tools are designed to support disaster recovery strategies, enabling businesses to protect critical information and minimize downtime, and maintain high availability in case of unexpected failures. In this section, you'll learn about these tools and how to implement them in your environment.
For strategies to design resilient clusters, see **[Availability and resilience](https://www.elastic.co/docs/deploy-manage/production-guidance/availability-and-resilience)**.
<note>
  The snapshot and restore and cross-cluster replication features are currently not available for Elastic Cloud Serverless projects. These features will be introduced in the future. For more information, refer to [Serverless differences](/docs/deploy-manage/deploy/elastic-cloud/differences-from-other-elasticsearch-offerings#elasticsearch-differences-serverless-feature-categories).
</note>


## Snapshot and restore

Snapshots in Elasticsearch are point-in-time backups that include your cluster's data, settings, and overall state. They capture all the information necessary to restore your cluster to a specific moment in time, making them essential for protecting data, recovering from unexpected issues, and transferring data between clusters. Snapshots are a reliable way to ensure the safety of your data and maintain the continuity of your operations.
You can perform the following tasks to manage snapshots and snapshot repositories:
- **[Register a repository](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/manage-snapshot-repositories):** Configure storage repositories (for example, S3, Azure, Google Cloud) to store snapshots. The way that you register repositories differs depending on your deployment method:
  - **[Elastic Cloud Hosted](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/elastic-cloud-hosted):** Deployments come with a preconfigured S3 repository for automatic backups, simplifying the setup process. You can also register external repositories, such as Azure, and Google Cloud, for more flexibility.
- **[Elastic Cloud Enterprise](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/cloud-enterprise):** Repository configuration is managed through the Elastic Cloud Enterprise user interface and automatically linked to deployments.
- **[Elastic Cloud on Kubernetes](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/cloud-on-k8s) and [self-managed](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/self-managed) deployments:** Repositories must be configured manually.
- **[Create snapshots](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/create-snapshots):** Manually or automatically create backups of your cluster.
- **[Restore a snapshot](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/restore-snapshot):** Recover indices, data streams, or the entire cluster to revert to a previous state. You can choose to restore specific parts of a snapshot, such as a single index, or perform a full restore.

To reduce storage costs for infrequently accessed data while maintaining access, you can also create **[searchable snapshots](https://www.elastic.co/docs/deploy-manage/tools/snapshot-and-restore/searchable-snapshots)**.
<note>
  Snapshot configurations vary across Elastic Cloud Hosted, Elastic Cloud Enterprise (ECE), Elastic Cloud on Kubernetes (ECK), and self-managed deployments.
</note>


## Cross-cluster replication (CCR)

**[Cross-cluster replication (CCR)](https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication)** is a feature in Elasticsearch that allows you to replicate data in real time from a leader cluster to one or more follower clusters. This replication ensures that data is synchronized across clusters, providing continuity, redundancy, and enhanced data accessibility.
CCR provides a way to automatically synchronize indices from a leader cluster to a follower cluster. This cluster could be in a different data center or even a different continent from the leader cluster. If the primary cluster fails, the secondary cluster can take over.
<note>
  CCR relies on **[remote clusters](https://www.elastic.co/docs/deploy-manage/remote-clusters)** functionality to establish and manage connections between the leader and the follower clusters.
</note>

You can perform the following tasks to manage cross-cluster replication:
- **[Set up CCR](https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication/set-up-cross-cluster-replication):** Configure leader and follower clusters for data replication.
- **[Manage CCR](https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication/manage-cross-cluster-replication):** Monitor and manage replicated indices.
- **[Automate replication](https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication/manage-auto-follow-patterns):** Use auto-follow patterns to automatically replicate newly created indices.
- **Set up failover clusters:** Configure **[uni-directional](https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication/uni-directional-disaster-recovery)** or **[bi-directional](https://www.elastic.co/docs/deploy-manage/tools/cross-cluster-replication/bi-directional-disaster-recovery)** CCR for redundancy and disaster recovery.
- **[Review cluster upgrade considerations when using CCR](https://www.elastic.co/docs/deploy-manage/upgrade):** If you're using CCR, then you might need to upgrade your clusters in a specific order to prevent errors. Review the considerations and recommended procedures for performing upgrades on CCR leaders and followers.